/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.core.integration.util.property.AuthProperties;
import com.epam.ta.reportportal.core.integration.util.property.BtsProperties;
import com.epam.ta.reportportal.core.integration.util.property.SauceLabsProperties;
import com.epam.ta.reportportal.entity.EmailSettingsEnum;
import com.epam.ta.reportportal.entity.integration.Integration;
import com.epam.ta.reportportal.ws.model.activity.IntegrationActivityResource;
import com.epam.ta.reportportal.ws.model.integration.AuthFlowEnum;
import com.epam.ta.reportportal.ws.model.integration.IntegrationResource;
import com.epam.ta.reportportal.ws.model.integration.IntegrationTypeResource;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class IntegrationConverter {
    public static final Function<Integration, IntegrationResource> TO_INTEGRATION_RESOURCE = integration -> {
        IntegrationResource resource = new IntegrationResource();
        resource.setId(integration.getId());
        resource.setName(integration.getName());
        resource.setCreator(integration.getCreator());
        resource.setCreationDate((Date)EntityUtils.TO_DATE.apply(integration.getCreationDate()));
        resource.setEnabled(Boolean.valueOf(integration.isEnabled()));
        Optional.ofNullable(integration.getProject()).ifPresent(p -> resource.setProjectId(p.getId()));
        Optional.ofNullable(integration.getParams()).ifPresent(it -> resource.setIntegrationParams(Optional.ofNullable(it.getParams()).map(p -> p.entrySet().stream().filter(entry -> !EmailSettingsEnum.PASSWORD.getAttribute().equalsIgnoreCase((String)entry.getKey())).filter(entry -> !SauceLabsProperties.ACCESS_TOKEN.getName().equalsIgnoreCase((String)entry.getKey())).filter(entry -> !BtsProperties.OAUTH_ACCESS_KEY.getName().equalsIgnoreCase((String)entry.getKey())).filter(entry -> !AuthProperties.MANAGER_PASSWORD.getName().equalsIgnoreCase((String)entry.getKey())).filter(entry -> null != entry.getValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).orElseGet(Collections::emptyMap)));
        IntegrationTypeResource type = new IntegrationTypeResource();
        type.setId(integration.getType().getId());
        type.setName(integration.getType().getName());
        type.setEnabled(integration.getType().isEnabled());
        type.setCreationDate((Date)EntityUtils.TO_DATE.apply(integration.getType().getCreationDate()));
        type.setGroupType(integration.getType().getIntegrationGroup().name());
        Optional.ofNullable(integration.getType().getDetails()).ifPresent(it -> type.setDetails(it.getDetails()));
        Optional.ofNullable(integration.getType().getAuthFlow()).ifPresent(it -> type.setAuthFlow(AuthFlowEnum.valueOf((String)it.name())));
        resource.setIntegrationType(type);
        return resource;
    };
    public static final Function<Integration, IntegrationActivityResource> TO_ACTIVITY_RESOURCE = integration -> {
        IntegrationActivityResource resource = new IntegrationActivityResource();
        resource.setId(integration.getId());
        resource.setName(integration.getName());
        Optional.ofNullable(integration.getProject()).ifPresent(p -> {
            resource.setProjectId(p.getId());
            resource.setProjectName(p.getName());
        });
        resource.setTypeName(integration.getType().getName());
        return resource;
    };

    private IntegrationConverter() {
    }
}

