/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.rabbit;

import com.epam.ta.reportportal.auth.basic.DatabaseUserDetailsService;
import com.epam.ta.reportportal.binary.AttachmentBinaryDataService;
import com.epam.ta.reportportal.commons.BinaryDataMetaInfo;
import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.configs.rabbit.DeserializablePair;
import com.epam.ta.reportportal.core.item.FinishTestItemHandler;
import com.epam.ta.reportportal.core.item.StartTestItemHandler;
import com.epam.ta.reportportal.core.item.TestItemService;
import com.epam.ta.reportportal.core.launch.FinishLaunchHandler;
import com.epam.ta.reportportal.core.launch.StartLaunchHandler;
import com.epam.ta.reportportal.core.logging.RabbitMessageLogging;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.attachment.AttachmentMetaInfo;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.log.Log;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.converter.builders.LogBuilder;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.epam.ta.reportportal.ws.rabbit.RequestType;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.AmqpRejectAndDontRequeueException;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;

public class AsyncReportingListener
implements MessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncReportingListener.class);
    @Autowired
    private MessageConverter messageConverter;
    @Autowired
    @Qualifier(value="rabbitTemplate")
    private AmqpTemplate amqpTemplate;
    @Autowired
    private StartLaunchHandler startLaunchHandler;
    @Autowired
    private FinishLaunchHandler finishLaunchHandler;
    @Autowired
    private StartTestItemHandler startTestItemHandler;
    @Autowired
    private FinishTestItemHandler finishTestItemHandler;
    @Autowired
    private DatabaseUserDetailsService userDetailsService;
    @Autowired
    private LogRepository logRepository;
    @Autowired
    private LaunchRepository launchRepository;
    @Autowired
    private TestItemRepository testItemRepository;
    @Autowired
    private TestItemService testItemService;
    @Autowired
    private AttachmentBinaryDataService attachmentBinaryDataService;

    @RabbitMessageLogging
    public void onMessage(Message message) {
        try {
            if (this.breakRetrying(message)) {
                return;
            }
            RequestType requestType = this.getRequestType(message);
            Map headers = message.getMessageProperties().getHeaders();
            switch (requestType) {
                case START_LAUNCH: {
                    this.onStartLaunch((StartLaunchRQ)this.messageConverter.fromMessage(message), (String)headers.get("username"), (String)headers.get("projectName"));
                    break;
                }
                case FINISH_LAUNCH: {
                    this.onFinishLaunch((FinishExecutionRQ)this.messageConverter.fromMessage(message), (String)headers.get("username"), (String)headers.get("projectName"), (String)headers.get("launchId"), (String)headers.get("baseUrl"));
                    break;
                }
                case START_TEST: {
                    this.onStartItem((StartTestItemRQ)this.messageConverter.fromMessage(message), (String)headers.get("username"), (String)headers.get("projectName"), (String)headers.get("parentItemId"));
                    break;
                }
                case FINISH_TEST: {
                    this.onFinishItem((FinishTestItemRQ)this.messageConverter.fromMessage(message), (String)headers.get("username"), (String)headers.get("projectName"), (String)headers.get("itemId"));
                    break;
                }
                case LOG: {
                    Jackson2JsonMessageConverter converter = (Jackson2JsonMessageConverter)this.messageConverter;
                    this.onLogCreate((DeserializablePair)converter.fromMessage(message, (Object)new ParameterizedTypeReference<DeserializablePair<SaveLogRQ, BinaryDataMetaInfo>>(){}), (Long)headers.get("projectId"));
                    break;
                }
                default: {
                    LOGGER.error("Unknown message type");
                    break;
                }
            }
        }
        catch (Throwable e) {
            if (e instanceof ReportPortalException && e.getMessage().startsWith("Test Item ")) {
                LOGGER.debug("exception : {}, message : {},  cause : {}", new Object[]{e.getClass().getName(), e.getMessage(), e.getCause() != null ? e.getCause().getMessage() : ""});
            } else {
                LOGGER.error("exception : {}, message : {},  cause : {}", new Object[]{e.getClass().getName(), e.getMessage(), e.getCause() != null ? e.getCause().getMessage() : ""});
            }
            throw new AmqpRejectAndDontRequeueException(e);
        }
    }

    public void onStartLaunch(StartLaunchRQ rq, String username, String projectName) {
        ReportPortalUser user = (ReportPortalUser)this.userDetailsService.loadUserByUsername(username);
        this.startLaunchHandler.startLaunch(user, ProjectExtractor.extractProjectDetails(user, projectName), rq);
    }

    public void onFinishLaunch(FinishExecutionRQ rq, String username, String projectName, String launchId, String baseUrl) {
        ReportPortalUser user = (ReportPortalUser)this.userDetailsService.loadUserByUsername(username);
        this.finishLaunchHandler.finishLaunch(launchId, rq, ProjectExtractor.extractProjectDetails(user, projectName), user, baseUrl);
    }

    public void onStartItem(StartTestItemRQ rq, String username, String projectName, String parentId) {
        ReportPortalUser user = (ReportPortalUser)this.userDetailsService.loadUserByUsername(username);
        ReportPortalUser.ProjectDetails projectDetails = ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName));
        if (!Strings.isNullOrEmpty((String)parentId)) {
            this.startTestItemHandler.startChildItem(user, projectDetails, rq, parentId);
        } else {
            this.startTestItemHandler.startRootItem(user, projectDetails, rq);
        }
    }

    public void onFinishItem(FinishTestItemRQ rq, String username, String projectName, String itemId) {
        ReportPortalUser user = (ReportPortalUser)this.userDetailsService.loadUserByUsername(username);
        this.finishTestItemHandler.finishTestItem(user, ProjectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), itemId, rq);
    }

    public void onLogCreate(DeserializablePair<SaveLogRQ, BinaryDataMetaInfo> payload, Long projectId) {
        SaveLogRQ request = payload.getLeft();
        BinaryDataMetaInfo metaInfo = payload.getRight();
        Optional itemOptional = this.testItemRepository.findByUuid(request.getItemUuid());
        if (StringUtils.isNotEmpty((CharSequence)payload.getLeft().getItemUuid()) && !itemOptional.isPresent()) {
            throw new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{payload.getLeft().getItemUuid()});
        }
        if (itemOptional.isPresent()) {
            this.createItemLog(request, (TestItem)itemOptional.get(), metaInfo, projectId);
        } else {
            Launch launch = (Launch)this.launchRepository.findByUuid(request.getLaunchUuid()).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{request.getLaunchUuid()}));
            this.createLaunchLog(request, launch, metaInfo, projectId);
        }
    }

    private boolean breakRetrying(Message message) {
        long count;
        List xdHeader = (List)message.getMessageProperties().getHeaders().get("x-death");
        if (xdHeader != null && (count = ((Long)((Map)xdHeader.get(0)).get("count")).longValue()) > 10L) {
            LOGGER.error("Dropping on maximum retry limit request of type = {}, for target id = {} ", (Object)this.getRequestType(message), (Object)this.getTargetId(message));
            this.amqpTemplate.send("reporting.retry", "reporting.dlq", message);
            return true;
        }
        return false;
    }

    private String getTargetId(Message message) {
        try {
            switch (this.getRequestType(message)) {
                case START_LAUNCH: {
                    return ((StartLaunchRQ)this.messageConverter.fromMessage(message)).getUuid();
                }
                case FINISH_LAUNCH: {
                    return (String)message.getMessageProperties().getHeaders().get("launchId");
                }
                case START_TEST: {
                    return ((StartTestItemRQ)this.messageConverter.fromMessage(message)).getUuid();
                }
                case FINISH_TEST: {
                    return (String)message.getMessageProperties().getHeaders().get("itemId");
                }
                case LOG: {
                    Jackson2JsonMessageConverter converter = (Jackson2JsonMessageConverter)this.messageConverter;
                    return ((SaveLogRQ)((DeserializablePair)converter.fromMessage(message, (Object)new ParameterizedTypeReference<DeserializablePair<SaveLogRQ, BinaryDataMetaInfo>>(){})).getLeft()).getUuid();
                }
            }
            return "";
        }
        catch (Throwable e) {
            return "";
        }
    }

    private void createItemLog(SaveLogRQ request, TestItem item, BinaryDataMetaInfo metaInfo, Long projectId) {
        Log log = new LogBuilder().addSaveLogRq(request).addTestItem(item).get();
        this.logRepository.save((Object)log);
        Launch effectiveLaunch = this.testItemService.getEffectiveLaunch(item);
        this.saveAttachment(metaInfo, log.getId(), projectId, effectiveLaunch.getId(), item.getItemId(), effectiveLaunch.getUuid(), log.getUuid());
    }

    private void createLaunchLog(SaveLogRQ request, Launch launch, BinaryDataMetaInfo metaInfo, Long projectId) {
        Log log = new LogBuilder().addSaveLogRq(request).addLaunch(launch).get();
        this.logRepository.save((Object)log);
        this.saveAttachment(metaInfo, log.getId(), projectId, launch.getId(), null, launch.getUuid(), log.getUuid());
    }

    private void saveAttachment(BinaryDataMetaInfo metaInfo, Long logId, Long projectId, Long launchId, Long itemId, String launchUuid, String logUuid) {
        if (!Objects.isNull(metaInfo)) {
            this.attachmentBinaryDataService.attachToLog(metaInfo, AttachmentMetaInfo.builder().withProjectId(projectId).withLaunchId(launchId).withItemId(itemId).withLogId(logId).withLaunchUuid(launchUuid).withLogUuid(logUuid).build());
        }
    }

    private void cleanup(DeserializablePair<SaveLogRQ, BinaryDataMetaInfo> payload) {
        if (payload.getRight() != null) {
            BinaryDataMetaInfo metaInfo = payload.getRight();
            this.attachmentBinaryDataService.delete(metaInfo.getFileId());
            this.attachmentBinaryDataService.delete(metaInfo.getThumbnailFileId());
        }
    }

    private RequestType getRequestType(Message message) {
        return RequestType.valueOf((String)message.getMessageProperties().getHeaders().get("requestType"));
    }
}

