/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.auth;

import com.epam.ta.reportportal.auth.util.AuthUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.dao.OAuth2AccessTokenRepository;
import com.epam.ta.reportportal.entity.user.StoredAccessToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.common.util.SerializationUtils;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtTokenStore;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="combinedTokenStore")
@Transactional(readOnly=true)
public class CombinedTokenStore
extends JwtTokenStore {
    @Autowired
    private OAuth2AccessTokenRepository oAuth2AccessTokenRepository;
    @Autowired
    private UserDetailsService userDetailsService;

    @Autowired
    public CombinedTokenStore(JwtAccessTokenConverter jwtTokenEnhancer) {
        super(jwtTokenEnhancer);
    }

    public OAuth2Authentication readAuthentication(OAuth2AccessToken token) {
        try {
            return super.readAuthentication(token);
        }
        catch (InvalidTokenException e) {
            return this.readAuthentication(token.getValue());
        }
    }

    public OAuth2Authentication readAuthentication(String tokenId) {
        try {
            return super.readAuthentication(tokenId);
        }
        catch (InvalidTokenException e) {
            StoredAccessToken accessToken = this.oAuth2AccessTokenRepository.findByTokenId(tokenId);
            ReportPortalUser userDetails = (ReportPortalUser)this.userDetailsService.loadUserByUsername(accessToken.getUserName());
            OAuth2Authentication authentication = AuthUtils.deserializeSafely(accessToken.getAuthentication(), auth -> {
                accessToken.setAuthentication(SerializationUtils.serialize((Object)auth));
                this.oAuth2AccessTokenRepository.save((Object)accessToken);
            });
            ReportPortalUser reportPortalUser = (ReportPortalUser)authentication.getPrincipal();
            reportPortalUser.setProjectDetails(userDetails.getProjectDetails());
            reportPortalUser.setUserRole(userDetails.getUserRole());
            return authentication;
        }
    }

    public OAuth2AccessToken readAccessToken(String tokenValue) {
        try {
            return super.readAccessToken(tokenValue);
        }
        catch (InvalidTokenException e) {
            StoredAccessToken token = this.oAuth2AccessTokenRepository.findByTokenId(tokenValue);
            if (token == null) {
                return null;
            }
            return (OAuth2AccessToken)SerializationUtils.deserialize((byte[])token.getToken());
        }
    }
}

