/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.strategy.analyze;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.analyzer.auto.strategy.analyze.AnalyzeItemsCollector;
import com.epam.ta.reportportal.core.item.UpdateTestItemHandler;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.LogLevel;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AutoAnalyzedCollector
implements AnalyzeItemsCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoAnalyzedCollector.class);
    private final TestItemRepository testItemRepository;
    private final LogRepository logRepository;
    private final LogIndexer logIndexer;
    private final UpdateTestItemHandler updateTestItemHandler;

    @Autowired
    public AutoAnalyzedCollector(TestItemRepository testItemRepository, LogRepository logRepository, LogIndexer logIndexer, UpdateTestItemHandler updateTestItemHandler) {
        this.testItemRepository = testItemRepository;
        this.logRepository = logRepository;
        this.logIndexer = logIndexer;
        this.updateTestItemHandler = updateTestItemHandler;
    }

    @Override
    public List<Long> collectItems(Long projectId, Long launchId, ReportPortalUser user) {
        List itemIds = this.testItemRepository.selectIdsByAnalyzedWithLevelGte(true, launchId, LogLevel.ERROR.toInt());
        Long deletedLogsCount = this.logIndexer.cleanIndex(projectId, this.logRepository.findIdsUnderTestItemByLaunchIdAndTestItemIdsAndLogLevelGte(launchId, itemIds, LogLevel.ERROR.toInt())).join();
        LOGGER.debug("{} logs deleted from analyzer", (Object)deletedLogsCount);
        this.updateTestItemHandler.resetItemsIssue(itemIds, projectId, user);
        return itemIds;
    }
}

