/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs;

import com.epam.ta.reportportal.binary.DataStoreService;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.entity.attachment.Attachment;
import com.epam.ta.reportportal.exception.ReportPortalException;
import java.io.InputStream;
import java.util.Optional;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.step.builder.AbstractTaskletStepBuilder;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StreamUtils;

@Configuration
@ConditionalOnProperty(name={"rp.attachments.recalculate"}, havingValue="true")
public class AttachmentSizeConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentSizeConfig.class);
    private static final int CHUNK_SIZE = 10;
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    @Autowired
    private DataSource dataSource;
    @Autowired
    @Qualifier(value="attachmentDataStoreService")
    private DataStoreService dataStoreService;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Bean
    public JdbcCursorItemReader<Attachment> reader() throws Exception {
        String query = "SELECT * from attachment order by id";
        JdbcCursorItemReader reader = new JdbcCursorItemReader();
        reader.setSql(query);
        reader.setDataSource(this.dataSource);
        reader.setRowMapper((rs, rowNum) -> {
            Attachment attachment = new Attachment();
            attachment.setId(Long.valueOf(rs.getLong("id")));
            attachment.setFileId(rs.getString("file_id"));
            return attachment;
        });
        reader.afterPropertiesSet();
        return reader;
    }

    @Bean
    public ItemProcessor<Attachment, Attachment> processor() {
        return item -> {
            Attachment attachment;
            block8: {
                Optional file = this.dataStoreService.load(item.getFileId());
                InputStream inputStream = (InputStream)file.get();
                try {
                    item.setFileSize((long)StreamUtils.copyToByteArray((InputStream)inputStream).length);
                    attachment = item;
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ReportPortalException e) {
                        LOGGER.debug((String)Suppliers.formattedSupplier((String)"File with id {} is not presented at the file system. Removing from the database.", (Object[])new Object[]{item.getId()}).get());
                        this.jdbcTemplate.update("DELETE FROM attachment WHERE id = ?", new Object[]{item.getId()});
                        return null;
                    }
                }
                inputStream.close();
            }
            return attachment;
        };
    }

    @Bean
    public ItemWriter<Attachment> writer() {
        return items -> items.forEach(item -> this.jdbcTemplate.update("UPDATE attachment SET file_size = ? WHERE id = ?", new Object[]{item.getFileSize(), item.getId()}));
    }

    @Bean
    public Step attachmentSizeStep() throws Exception {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("attachment").chunk(10).reader(this.reader()).processor(this.processor()).writer(this.writer()).allowStartIfComplete(true)).build();
    }
}

