/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.dashboard.impl;

import com.epam.ta.reportportal.auth.acl.ShareableObjectsHandler;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.dashboard.UpdateDashboardHandler;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.DashboardUpdatedEvent;
import com.epam.ta.reportportal.core.events.activity.WidgetDeletedEvent;
import com.epam.ta.reportportal.core.shareable.GetShareableEntityHandler;
import com.epam.ta.reportportal.core.widget.UpdateWidgetHandler;
import com.epam.ta.reportportal.core.widget.content.remover.WidgetContentRemover;
import com.epam.ta.reportportal.dao.DashboardRepository;
import com.epam.ta.reportportal.dao.DashboardWidgetRepository;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.dashboard.Dashboard;
import com.epam.ta.reportportal.entity.dashboard.DashboardWidget;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.builders.DashboardBuilder;
import com.epam.ta.reportportal.ws.converter.converters.DashboardConverter;
import com.epam.ta.reportportal.ws.converter.converters.WidgetConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.activity.DashboardActivityResource;
import com.epam.ta.reportportal.ws.model.dashboard.AddWidgetRq;
import com.epam.ta.reportportal.ws.model.dashboard.UpdateDashboardRQ;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdateDashboardHandlerImpl
implements UpdateDashboardHandler {
    private final DashboardWidgetRepository dashboardWidgetRepository;
    private final DashboardRepository dashboardRepository;
    private final UpdateWidgetHandler updateWidgetHandler;
    private final List<WidgetContentRemover> widgetContentRemovers;
    private final WidgetRepository widgetRepository;
    private final MessageBus messageBus;
    private final GetShareableEntityHandler<Dashboard> getShareableDashboardHandler;
    private final GetShareableEntityHandler<Widget> getShareableWidgetHandler;
    private final ShareableObjectsHandler aclHandler;

    @Autowired
    public UpdateDashboardHandlerImpl(DashboardRepository dashboardRepository, UpdateWidgetHandler updateWidgetHandler, List<WidgetContentRemover> widgetContentRemovers, MessageBus messageBus, GetShareableEntityHandler<Dashboard> getShareableDashboardHandler, GetShareableEntityHandler<Widget> getShareableWidgetHandler, ShareableObjectsHandler aclHandler, DashboardWidgetRepository dashboardWidgetRepository, WidgetRepository widgetRepository) {
        this.dashboardRepository = dashboardRepository;
        this.updateWidgetHandler = updateWidgetHandler;
        this.widgetContentRemovers = widgetContentRemovers;
        this.messageBus = messageBus;
        this.getShareableDashboardHandler = getShareableDashboardHandler;
        this.getShareableWidgetHandler = getShareableWidgetHandler;
        this.aclHandler = aclHandler;
        this.dashboardWidgetRepository = dashboardWidgetRepository;
        this.widgetRepository = widgetRepository;
    }

    @Override
    public OperationCompletionRS updateDashboard(ReportPortalUser.ProjectDetails projectDetails, UpdateDashboardRQ rq, Long dashboardId, ReportPortalUser user) {
        Dashboard dashboard = this.getShareableDashboardHandler.getAdministrated(dashboardId, projectDetails);
        DashboardActivityResource before = DashboardConverter.TO_ACTIVITY_RESOURCE.apply(dashboard);
        if (!dashboard.getName().equals(rq.getName())) {
            BusinessRule.expect((Object)this.dashboardRepository.existsByNameAndOwnerAndProjectId(rq.getName(), user.getUsername(), projectDetails.getProjectId()), BooleanUtils::isFalse).verify(ErrorType.RESOURCE_ALREADY_EXISTS, new Object[]{rq.getName()});
        }
        dashboard = new DashboardBuilder(dashboard).addUpdateRq(rq).get();
        this.dashboardRepository.save((Object)dashboard);
        if (before.isShared() != dashboard.isShared()) {
            this.aclHandler.updateAcl(dashboard, projectDetails.getProjectId(), dashboard.isShared());
            this.updateWidgetHandler.updateSharing(dashboard.getDashboardWidgets().stream().map(DashboardWidget::getWidget).collect(Collectors.toList()), projectDetails.getProjectId(), dashboard.isShared());
        }
        this.messageBus.publishActivity(new DashboardUpdatedEvent(before, DashboardConverter.TO_ACTIVITY_RESOURCE.apply(dashboard), user.getUserId(), user.getUsername()));
        return new OperationCompletionRS("Dashboard with ID = '" + dashboard.getId() + "' successfully updated");
    }

    @Override
    public OperationCompletionRS addWidget(Long dashboardId, ReportPortalUser.ProjectDetails projectDetails, AddWidgetRq rq, ReportPortalUser user) {
        Dashboard dashboard = this.getShareableDashboardHandler.getAdministrated(dashboardId, projectDetails);
        BusinessRule.expect((Object)dashboard.getDashboardWidgets().stream().map(dw -> dw.getId().getWidgetId()).anyMatch(widgetId -> widgetId.equals(rq.getAddWidget().getWidgetId())), BooleanUtils::isFalse).verify(ErrorType.DASHBOARD_UPDATE_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Widget with ID = '{}' is already added to the dashboard with ID = '{}'", (Object[])new Object[]{rq.getAddWidget().getWidgetId(), dashboard.getId()})});
        Widget widget = this.getShareableWidgetHandler.getPermitted(rq.getAddWidget().getWidgetId(), projectDetails);
        boolean isCreatedOnDashboard = CollectionUtils.isEmpty((Collection)widget.getDashboardWidgets());
        DashboardWidget dashboardWidget = WidgetConverter.toDashboardWidget(rq.getAddWidget(), dashboard, widget, isCreatedOnDashboard);
        this.dashboardWidgetRepository.save((Object)dashboardWidget);
        return new OperationCompletionRS("Widget with ID = '" + widget.getId() + "' was successfully added to the dashboard with ID = '" + dashboard.getId() + "'");
    }

    @Override
    public OperationCompletionRS removeWidget(Long widgetId, Long dashboardId, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        Dashboard dashboard = this.getShareableDashboardHandler.getPermitted(dashboardId, projectDetails);
        Widget widget = this.getShareableWidgetHandler.getPermitted(widgetId, projectDetails);
        if (user.getUsername().equalsIgnoreCase(widget.getOwner())) {
            OperationCompletionRS result = this.deleteWidget(widget);
            this.messageBus.publishActivity(new WidgetDeletedEvent(WidgetConverter.TO_ACTIVITY_RESOURCE.apply(widget), user.getUserId(), user.getUsername()));
            return result;
        }
        DashboardWidget toRemove = dashboard.getDashboardWidgets().stream().filter(dashboardWidget -> widget.getId().equals(dashboardWidget.getId().getWidgetId())).findFirst().orElseThrow(() -> new ReportPortalException(ErrorType.WIDGET_NOT_FOUND_IN_DASHBOARD, new Object[]{widgetId, dashboardId}));
        this.dashboardWidgetRepository.delete((Object)toRemove);
        return new OperationCompletionRS("Widget with ID = '" + widget.getId() + "' was successfully removed from the dashboard with ID = '" + dashboard.getId() + "'");
    }

    private OperationCompletionRS deleteWidget(Widget widget) {
        this.widgetContentRemovers.forEach(remover -> remover.removeContent(widget));
        this.dashboardWidgetRepository.deleteAll((Iterable)widget.getDashboardWidgets());
        this.widgetRepository.delete((Object)widget);
        this.aclHandler.deleteAclForObject(widget);
        return new OperationCompletionRS("Widget with ID = '" + widget.getId() + "' was successfully deleted from the system.");
    }
}

