/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.events.attachment.DeleteTestItemAttachmentsEvent;
import com.epam.ta.reportportal.core.item.DeleteTestItemHandler;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.LogLevel;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.project.ProjectRole;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class DeleteTestItemHandlerImpl
implements DeleteTestItemHandler {
    private final TestItemRepository testItemRepository;
    private final LogRepository logRepository;
    private final LogIndexer logIndexer;
    private final LaunchRepository launchRepository;
    private final ApplicationEventPublisher eventPublisher;
    private static final Function<Long, OperationCompletionRS> COMPOSE_DELETE_RESPONSE = it -> {
        String message = (String)Suppliers.formattedSupplier((String)"Test Item with ID = '{}' has been successfully deleted.", (Object[])new Object[]{it}).get();
        return new OperationCompletionRS(message);
    };

    @Autowired
    public DeleteTestItemHandlerImpl(TestItemRepository testItemRepository, LogRepository logRepository, LogIndexer logIndexer, LaunchRepository launchRepository, ApplicationEventPublisher eventPublisher) {
        this.testItemRepository = testItemRepository;
        this.logRepository = logRepository;
        this.logIndexer = logIndexer;
        this.launchRepository = launchRepository;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public OperationCompletionRS deleteTestItem(Long itemId, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        TestItem item = (TestItem)this.testItemRepository.findById((Object)itemId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{itemId}));
        Launch launch = (Launch)this.launchRepository.findById((Object)item.getLaunchId()).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{item.getLaunchId()}));
        this.validate(item, launch, user, projectDetails);
        Optional<TestItem> parent = Optional.ofNullable(item.getParent());
        HashSet removedDescendants = Sets.newHashSet((Iterable)this.testItemRepository.selectAllDescendantsIds(item.getPath()));
        this.testItemRepository.deleteById((Object)item.getItemId());
        launch.setHasRetries(this.launchRepository.hasRetries(launch.getId()));
        parent.ifPresent(p -> p.setHasChildren(this.testItemRepository.hasChildren(p.getItemId(), p.getPath())));
        this.logIndexer.cleanIndex(projectDetails.getProjectId(), this.logRepository.findIdsUnderTestItemByLaunchIdAndTestItemIdsAndLogLevelGte(launch.getId(), List.copyOf(removedDescendants), LogLevel.ERROR.toInt()));
        this.eventPublisher.publishEvent((Object)new DeleteTestItemAttachmentsEvent(removedDescendants));
        return COMPOSE_DELETE_RESPONSE.apply(item.getItemId());
    }

    @Override
    public List<OperationCompletionRS> deleteTestItems(Collection<Long> ids, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        List items = this.testItemRepository.findAllById(ids);
        Set itemIds = items.stream().map(TestItem::getItemId).collect(Collectors.toSet());
        List launches = this.launchRepository.findAllById((Iterable)items.stream().map(TestItem::getLaunchId).filter(Objects::nonNull).collect(Collectors.toSet()));
        Map<Long, List<TestItem>> launchItemMap = items.stream().collect(Collectors.groupingBy(TestItem::getLaunchId));
        launches.forEach(launch -> ((List)launchItemMap.get(launch.getId())).forEach(item -> this.validate((TestItem)item, (Launch)launch, user, projectDetails)));
        Map descendantsMapping = this.testItemRepository.selectPathNames(itemIds, projectDetails.getProjectId());
        HashSet idsToDelete = Sets.newHashSet(descendantsMapping.keySet());
        descendantsMapping.forEach((key, value) -> value.getItemPaths().forEach(ip -> {
            if (idsToDelete.contains(ip.getId())) {
                idsToDelete.remove(key);
            }
        }));
        List<TestItem> parentsToUpdate = items.stream().filter(it -> idsToDelete.contains(it.getItemId())).map(TestItem::getParent).filter(Objects::nonNull).collect(Collectors.toList());
        launchItemMap.forEach((launchId, testItemIds) -> this.logIndexer.cleanIndex(projectDetails.getProjectId(), this.logRepository.findIdsUnderTestItemByLaunchIdAndTestItemIdsAndLogLevelGte(launchId, testItemIds.stream().map(TestItem::getItemId).filter(idsToDelete::contains).collect(Collectors.toList()), LogLevel.ERROR.toInt())));
        Set removedItems = this.testItemRepository.findAllById((Iterable)idsToDelete).stream().map(TestItem::getPath).collect(Collectors.toList()).stream().flatMap(path -> this.testItemRepository.selectAllDescendantsIds(path).stream()).collect(Collectors.toSet());
        this.testItemRepository.deleteAllByItemIdIn((Collection)idsToDelete);
        launches.forEach(it -> it.setHasRetries(this.launchRepository.hasRetries(it.getId())));
        parentsToUpdate.forEach(it -> it.setHasChildren(this.testItemRepository.hasChildren(it.getItemId(), it.getPath())));
        idsToDelete.forEach(it -> this.eventPublisher.publishEvent((Object)new DeleteTestItemAttachmentsEvent(removedItems)));
        return idsToDelete.stream().map(COMPOSE_DELETE_RESPONSE).collect(Collectors.toList());
    }

    private void validate(TestItem testItem, Launch launch, ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails) {
        if (user.getUserRole() != UserRole.ADMINISTRATOR) {
            BusinessRule.expect((Object)launch.getProjectId(), (Predicate)Predicates.equalTo((Object)projectDetails.getProjectId())).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Deleting testItem '{}' is not under specified project '{}'", (Object[])new Object[]{testItem.getItemId(), projectDetails.getProjectId()})});
            if (projectDetails.getProjectRole().lowerThan(ProjectRole.PROJECT_MANAGER)) {
                BusinessRule.expect((Object)user.getUserId(), Predicate.isEqual(launch.getUserId())).verify(ErrorType.ACCESS_DENIED, new Object[]{"You are not a launch owner."});
            }
        }
        BusinessRule.expect((Object)testItem.getRetryOf(), Objects::isNull).verify(ErrorType.RETRIES_HANDLER_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unable to delete test item ['{}'] because it is a retry", (Object[])new Object[]{testItem.getItemId()}).get()});
        BusinessRule.expect((Object)testItem.getItemResults().getStatus(), (Predicate)Predicates.not(it -> it.equals((Object)StatusEnum.IN_PROGRESS))).verify(ErrorType.TEST_ITEM_IS_NOT_FINISHED, new Object[]{Suppliers.formattedSupplier((String)"Unable to delete test item ['{}'] in progress state", (Object[])new Object[]{testItem.getItemId()})});
        BusinessRule.expect((Object)launch.getStatus(), (Predicate)Predicates.not(it -> it.equals((Object)StatusEnum.IN_PROGRESS))).verify(ErrorType.LAUNCH_IS_NOT_FINISHED, new Object[]{Suppliers.formattedSupplier((String)"Unable to delete test item ['{}'] under launch ['{}'] with 'In progress' state", (Object[])new Object[]{testItem.getItemId(), launch.getId()})});
    }
}

