/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.merge.strategy;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.item.identity.IdentityUtil;
import com.epam.ta.reportportal.core.item.identity.TestItemUniqueIdGenerator;
import com.epam.ta.reportportal.core.item.merge.LaunchMergeStrategy;
import com.epam.ta.reportportal.dao.AttachmentRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.ItemAttribute;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.enums.TestItemTypeEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.builders.LaunchBuilder;
import com.epam.ta.reportportal.ws.converter.converters.ItemAttributeConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributeResource;
import com.epam.ta.reportportal.ws.model.launch.MergeLaunchesRQ;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public abstract class AbstractLaunchMergeStrategy
implements LaunchMergeStrategy {
    protected final LaunchRepository launchRepository;
    private final TestItemRepository testItemRepository;
    private final LogRepository logRepository;
    private final AttachmentRepository attachmentRepository;
    private final TestItemUniqueIdGenerator identifierGenerator;

    protected AbstractLaunchMergeStrategy(LaunchRepository launchRepository, TestItemRepository testItemRepository, LogRepository logRepository, AttachmentRepository attachmentRepository, TestItemUniqueIdGenerator identifierGenerator) {
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
        this.logRepository = logRepository;
        this.attachmentRepository = attachmentRepository;
        this.identifierGenerator = identifierGenerator;
    }

    protected Launch createNewLaunch(ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, MergeLaunchesRQ rq, List<Launch> launchesList) {
        Launch newLaunch = this.createResultedLaunch(projectDetails.getProjectId(), user.getUserId(), rq, launchesList);
        boolean isNameChanged = !newLaunch.getName().equals(launchesList.get(0).getName());
        this.updateChildrenOfLaunches(newLaunch, rq.getLaunches(), rq.isExtendSuitesDescription(), isNameChanged);
        return newLaunch;
    }

    private Launch createResultedLaunch(Long projectId, Long userId, MergeLaunchesRQ mergeLaunchesRQ, List<Launch> launches) {
        Date startTime = Optional.ofNullable(mergeLaunchesRQ.getStartTime()).orElse((Date)EntityUtils.TO_DATE.apply(launches.stream().min(Comparator.comparing(Launch::getStartTime)).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Invalid launches"})).getStartTime()));
        Date endTime = Optional.ofNullable(mergeLaunchesRQ.getEndTime()).orElse((Date)EntityUtils.TO_DATE.apply(launches.stream().max(Comparator.comparing(Launch::getEndTime)).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Invalid launches"})).getEndTime()));
        BusinessRule.expect((Object)endTime, time -> !time.before(startTime)).verify(ErrorType.FINISH_TIME_EARLIER_THAN_START_TIME, new Object[]{EntityUtils.TO_LOCAL_DATE_TIME.apply(endTime), startTime, projectId});
        StartLaunchRQ startRQ = new StartLaunchRQ();
        startRQ.setMode(Optional.ofNullable(mergeLaunchesRQ.getMode()).orElse(Mode.DEFAULT));
        startRQ.setDescription(Optional.ofNullable(mergeLaunchesRQ.getDescription()).orElse(launches.stream().map(Launch::getDescription).collect(Collectors.joining("\n\n"))));
        startRQ.setName(Optional.ofNullable(mergeLaunchesRQ.getName()).orElse("Merged: " + launches.stream().map(Launch::getName).distinct().collect(Collectors.joining(", "))));
        startRQ.setStartTime(startTime);
        Launch launch = new LaunchBuilder().addStartRQ(startRQ).addProject(projectId).addStatus(StatusEnum.IN_PROGRESS.name()).addUserId(userId).addEndTime(endTime).get();
        launch.setHasRetries(launches.stream().anyMatch(Launch::isHasRetries));
        this.launchRepository.save((Object)launch);
        this.launchRepository.refresh((Object)launch);
        this.mergeAttributes(mergeLaunchesRQ.getAttributes(), launches, launch);
        return launch;
    }

    private void mergeAttributes(Set<ItemAttributeResource> attributesFromRq, List<Launch> launchesToMerge, Launch resultedLaunch) {
        HashSet mergedAttributes = Sets.newHashSet();
        if (attributesFromRq == null) {
            mergedAttributes.addAll(launchesToMerge.stream().map(Launch::getAttributes).flatMap(Collection::stream).peek(it -> it.setLaunch(resultedLaunch)).collect(Collectors.toSet()));
        } else {
            mergedAttributes.addAll(launchesToMerge.stream().map(Launch::getAttributes).flatMap(Collection::stream).filter(ItemAttribute::isSystem).peek(it -> it.setLaunch(resultedLaunch)).collect(Collectors.toSet()));
            mergedAttributes.addAll(attributesFromRq.stream().map(ItemAttributeConverter.FROM_RESOURCE).peek(attr -> attr.setLaunch(resultedLaunch)).collect(Collectors.toSet()));
        }
        resultedLaunch.setAttributes((Set)mergedAttributes);
    }

    private void updateChildrenOfLaunches(Launch newLaunch, Set<Long> launches, boolean extendDescription, boolean isNameChanged) {
        List testItems = launches.stream().peek(id -> {
            this.logRepository.updateLaunchIdByLaunchId(id, newLaunch.getId());
            this.attachmentRepository.updateLaunchIdByProjectIdAndLaunchId(newLaunch.getProjectId(), id, newLaunch.getId());
        }).flatMap(id -> {
            Launch launch = (Launch)this.launchRepository.findById(id).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{id}));
            return this.testItemRepository.findTestItemsByLaunchId(launch.getId()).stream().peek(testItem -> {
                testItem.setLaunchId(newLaunch.getId());
                if (isNameChanged && this.identifierGenerator.validate(testItem.getUniqueId())) {
                    testItem.setUniqueId(this.identifierGenerator.generate((TestItem)testItem, IdentityUtil.getParentIds(testItem), newLaunch));
                }
                if (testItem.getType().sameLevel(TestItemTypeEnum.SUITE)) {
                    Supplier newDescription = Suppliers.formattedSupplier((String)((null != testItem.getDescription() ? testItem.getDescription() : "") + (extendDescription ? "\r\n@launch '{} #{}'" : "")), (Object[])new Object[]{launch.getName(), launch.getNumber()});
                    testItem.setDescription((String)newDescription.get());
                }
            });
        }).collect(Collectors.toList());
        this.testItemRepository.saveAll(testItems);
    }
}

