/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.merge.strategy;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.item.identity.TestItemUniqueIdGenerator;
import com.epam.ta.reportportal.core.item.impl.merge.strategy.AbstractLaunchMergeStrategy;
import com.epam.ta.reportportal.core.item.impl.merge.strategy.MergeStrategyType;
import com.epam.ta.reportportal.core.item.impl.merge.strategy.StatisticsCalculationFactory;
import com.epam.ta.reportportal.dao.AttachmentRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.ws.model.launch.MergeLaunchesRQ;
import java.util.List;

public class BasicLaunchMergeStrategy
extends AbstractLaunchMergeStrategy {
    private final StatisticsCalculationFactory statisticsCalculationFactory;

    public BasicLaunchMergeStrategy(LaunchRepository launchRepository, TestItemRepository testItemRepository, LogRepository logRepository, AttachmentRepository attachmentRepository, TestItemUniqueIdGenerator identifierGenerator, StatisticsCalculationFactory statisticsCalculationFactory) {
        super(launchRepository, testItemRepository, logRepository, attachmentRepository, identifierGenerator);
        this.statisticsCalculationFactory = statisticsCalculationFactory;
    }

    @Override
    public Launch mergeLaunches(ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, MergeLaunchesRQ rq, List<Launch> launchesList) {
        Launch newLaunch = this.createNewLaunch(projectDetails, user, rq, launchesList);
        newLaunch.setStatistics(this.statisticsCalculationFactory.getStrategy(MergeStrategyType.BASIC).recalculateLaunchStatistics(newLaunch, launchesList));
        this.launchRepository.save((Object)newLaunch);
        return newLaunch;
    }
}

