/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.status;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.TestItemStatusChangedEvent;
import com.epam.ta.reportportal.core.item.impl.status.ChangeStatusHandler;
import com.epam.ta.reportportal.core.item.impl.status.StatusChangingStrategy;
import com.epam.ta.reportportal.dao.IssueEntityRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.item.issue.IssueEntity;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.jooq.enums.JStatusEnum;
import com.epam.ta.reportportal.ws.converter.converters.TestItemConverter;
import com.epam.ta.reportportal.ws.model.activity.TestItemActivityResource;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChangeStatusHandlerImpl
implements ChangeStatusHandler {
    private final TestItemRepository testItemRepository;
    private final IssueEntityRepository issueEntityRepository;
    private final MessageBus messageBus;
    private final LaunchRepository launchRepository;
    private final Map<StatusEnum, StatusChangingStrategy> statusChangingStrategyMapping;

    @Autowired
    public ChangeStatusHandlerImpl(TestItemRepository testItemRepository, IssueEntityRepository issueEntityRepository, MessageBus messageBus, LaunchRepository launchRepository, Map<StatusEnum, StatusChangingStrategy> statusChangingStrategyMapping) {
        this.testItemRepository = testItemRepository;
        this.issueEntityRepository = issueEntityRepository;
        this.messageBus = messageBus;
        this.launchRepository = launchRepository;
        this.statusChangingStrategyMapping = statusChangingStrategyMapping;
    }

    @Override
    public void changeParentStatus(Long childId, Long projectId, ReportPortalUser user) {
        this.testItemRepository.findParentByChildId(childId).ifPresent(parent -> {
            if (parent.isHasChildren()) {
                Optional.ofNullable(parent.getItemResults().getIssue()).map(IssueEntity::getIssueId).ifPresent(arg_0 -> ((IssueEntityRepository)this.issueEntityRepository).deleteById(arg_0));
            }
            if (this.isParentStatusUpdateRequired((TestItem)parent)) {
                StatusEnum resolvedStatus = this.resolveStatus(parent.getItemId());
                if (parent.getItemResults().getStatus() != resolvedStatus) {
                    TestItemActivityResource before = TestItemConverter.TO_ACTIVITY_RESOURCE.apply((TestItem)parent, projectId);
                    this.changeStatus((TestItem)parent, resolvedStatus, user);
                    this.messageBus.publishActivity(new TestItemStatusChangedEvent(before, TestItemConverter.TO_ACTIVITY_RESOURCE.apply((TestItem)parent, projectId), user.getUserId(), user.getUsername()));
                    this.changeParentStatus(parent.getItemId(), projectId, user);
                }
            }
        });
    }

    private boolean isParentStatusUpdateRequired(TestItem parent) {
        return parent.getItemResults().getStatus() != StatusEnum.IN_PROGRESS && !this.testItemRepository.hasItemsInStatusByParent(parent.getItemId(), parent.getPath(), new String[]{StatusEnum.IN_PROGRESS.name()});
    }

    private StatusEnum resolveStatus(Long itemId) {
        return this.testItemRepository.hasDescendantsNotInStatus(itemId, new String[]{StatusEnum.PASSED.name(), StatusEnum.INFO.name(), StatusEnum.WARN.name()}) ? StatusEnum.FAILED : StatusEnum.PASSED;
    }

    private void changeStatus(TestItem parent, StatusEnum resolvedStatus, ReportPortalUser user) {
        if (parent.isHasChildren() || !parent.isHasStats()) {
            parent.getItemResults().setStatus(resolvedStatus);
        } else {
            Optional<StatusChangingStrategy> statusChangingStrategy = Optional.ofNullable(this.statusChangingStrategyMapping.get(resolvedStatus));
            if (statusChangingStrategy.isPresent()) {
                statusChangingStrategy.get().changeStatus(parent, resolvedStatus, user);
            } else {
                parent.getItemResults().setStatus(resolvedStatus);
            }
        }
    }

    @Override
    public void changeLaunchStatus(Launch launch) {
        if (launch.getStatus() != StatusEnum.IN_PROGRESS && !this.launchRepository.hasItemsInStatuses(launch.getId(), (List)Lists.newArrayList((Object[])new JStatusEnum[]{JStatusEnum.IN_PROGRESS}))) {
            StatusEnum launchStatus = this.launchRepository.hasRootItemsWithStatusNotEqual(launch.getId(), new String[]{StatusEnum.PASSED.name(), StatusEnum.INFO.name(), StatusEnum.WARN.name()}) ? StatusEnum.FAILED : StatusEnum.PASSED;
            launch.setStatus(launchStatus);
        }
    }
}

