/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.rerun;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.LaunchStartedEvent;
import com.epam.ta.reportportal.core.events.item.ItemRetryEvent;
import com.epam.ta.reportportal.core.item.identity.IdentityUtil;
import com.epam.ta.reportportal.core.item.identity.TestCaseHashGenerator;
import com.epam.ta.reportportal.core.item.identity.UniqueIdGenerator;
import com.epam.ta.reportportal.core.item.impl.retry.RetriesHandler;
import com.epam.ta.reportportal.core.launch.rerun.RerunHandler;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.LaunchModeEnum;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.builders.TestCaseIdEntry;
import com.epam.ta.reportportal.ws.converter.builders.TestItemBuilder;
import com.epam.ta.reportportal.ws.converter.converters.ItemAttributeConverter;
import com.epam.ta.reportportal.ws.converter.converters.LaunchConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import com.epam.ta.reportportal.ws.model.item.ItemCreatedRS;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRS;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class RerunHandlerImpl
implements RerunHandler {
    private final TestItemRepository testItemRepository;
    private final LaunchRepository launchRepository;
    private final UniqueIdGenerator uniqueIdGenerator;
    private final TestCaseHashGenerator testCaseHashGenerator;
    private final MessageBus messageBus;
    private final ApplicationEventPublisher eventPublisher;
    private final RetriesHandler retriesHandler;

    @Autowired
    public RerunHandlerImpl(TestItemRepository testItemRepository, LaunchRepository launchRepository, UniqueIdGenerator uniqueIdGenerator, TestCaseHashGenerator testCaseHashGenerator, MessageBus messageBus, ApplicationEventPublisher eventPublisher, RetriesHandler retriesHandler) {
        this.testItemRepository = testItemRepository;
        this.launchRepository = launchRepository;
        this.uniqueIdGenerator = uniqueIdGenerator;
        this.testCaseHashGenerator = testCaseHashGenerator;
        this.messageBus = messageBus;
        this.eventPublisher = eventPublisher;
        this.retriesHandler = retriesHandler;
    }

    @Override
    public StartLaunchRS handleLaunch(StartLaunchRQ request, Long projectId, ReportPortalUser user) {
        Optional launchOptional = StringUtils.isEmpty((CharSequence)request.getRerunOf()) ? this.launchRepository.findLatestByNameAndProjectId(request.getName(), projectId) : this.launchRepository.findByUuid(request.getRerunOf());
        Launch launch = (Launch)launchOptional.orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{Optional.ofNullable(request.getRerunOf()).orElse(request.getName())}));
        Optional.ofNullable(request.getMode()).map(it -> LaunchModeEnum.valueOf((String)it.name())).ifPresent(arg_0 -> ((Launch)launch).setMode(arg_0));
        Optional.ofNullable(request.getDescription()).ifPresent(arg_0 -> ((Launch)launch).setDescription(arg_0));
        launch.setStatus(StatusEnum.IN_PROGRESS);
        Optional.ofNullable(request.getAttributes()).map(it -> it.stream().map(attr -> ItemAttributeConverter.TO_LAUNCH_ATTRIBUTE.apply((ItemAttributesRQ)attr, launch)).collect(Collectors.toSet())).ifPresent(arg_0 -> ((Launch)launch).setAttributes(arg_0));
        Optional.ofNullable(request.getUuid()).ifPresent(arg_0 -> ((Launch)launch).setUuid(arg_0));
        launch.setRerun(true);
        this.messageBus.publishActivity(new LaunchStartedEvent(LaunchConverter.TO_ACTIVITY_RESOURCE.apply(launch), user.getUserId(), user.getUsername()));
        StartLaunchRS response = new StartLaunchRS();
        response.setId(launch.getUuid());
        response.setNumber(launch.getNumber());
        return response;
    }

    @Override
    public Optional<ItemCreatedRS> handleRootItem(StartTestItemRQ request, Launch launch) {
        TestCaseIdEntry testCaseIdEntry = TestItemBuilder.processTestCaseId(request);
        return Optional.ofNullable(testCaseIdEntry.getId()).map(testCaseId -> this.updateRootItem(testCaseIdEntry.getHash(), request, launch)).orElseGet(() -> {
            TestItem newItem = new TestItemBuilder().addStartItemRequest(request).get();
            Integer testCaseHash = this.testCaseHashGenerator.generate(newItem, Collections.emptyList(), launch.getProjectId());
            return this.updateRootItem(testCaseHash, request, launch);
        });
    }

    private Optional<ItemCreatedRS> updateRootItem(Integer testCaseHash, StartTestItemRQ request, Launch launch) {
        return this.testItemRepository.findLatestByTestCaseHashAndLaunchIdWithoutParents(testCaseHash, launch.getId()).map(foundItem -> this.updateRootItem(request, (TestItem)foundItem));
    }

    private ItemCreatedRS updateRootItem(StartTestItemRQ request, TestItem foundItem) {
        foundItem = new TestItemBuilder(foundItem).addDescription(request.getDescription()).overwriteAttributes(request.getAttributes()).addStatus(StatusEnum.IN_PROGRESS).get();
        Optional.ofNullable(request.getUuid()).ifPresent(arg_0 -> ((TestItem)foundItem).setUuid(arg_0));
        return new ItemCreatedRS(foundItem.getUuid(), foundItem.getUniqueId());
    }

    @Override
    public Optional<ItemCreatedRS> handleChildItem(StartTestItemRQ request, Launch launch, TestItem parent) {
        if (!request.isHasStats()) {
            return Optional.empty();
        }
        TestItem newItem = new TestItemBuilder().addLaunchId(launch.getId()).addStartItemRequest(request).addAttributes(request.getAttributes()).addParent(parent).get();
        if (Objects.isNull(newItem.getTestCaseId())) {
            newItem.setTestCaseHash(this.testCaseHashGenerator.generate(newItem, IdentityUtil.getItemTreeIds(parent), launch.getProjectId()));
        }
        return this.testItemRepository.findLatestByTestCaseHashAndLaunchIdAndParentId(newItem.getTestCaseHash(), launch.getId(), parent.getItemId()).map(foundItem -> foundItem.isHasChildren() ? this.updateRootItem(request, (TestItem)foundItem) : this.handleRetry(launch, newItem, (TestItem)foundItem, parent));
    }

    private ItemCreatedRS handleRetry(Launch launch, TestItem newItem, TestItem foundItem, TestItem parentItem) {
        this.eventPublisher.publishEvent((Object)ItemRetryEvent.of(launch.getProjectId(), launch.getId(), foundItem.getItemId()));
        this.testItemRepository.save((Object)newItem);
        newItem.setPath(parentItem.getPath() + "." + newItem.getItemId());
        this.generateUniqueId(launch, newItem);
        this.retriesHandler.handleRetries(launch, newItem, foundItem.getUuid());
        return new ItemCreatedRS(newItem.getUuid(), newItem.getUniqueId());
    }

    private void generateUniqueId(Launch launch, TestItem item) {
        if (null == item.getUniqueId()) {
            item.setUniqueId(this.uniqueIdGenerator.generate(item, IdentityUtil.getParentIds(item), launch));
        }
    }
}

