/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader;

import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.widget.content.LoadContentStrategy;
import com.epam.ta.reportportal.core.widget.util.WidgetFilterUtil;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.dao.WidgetContentRepository;
import com.epam.ta.reportportal.entity.widget.WidgetOptions;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class ActivityContentLoader
implements LoadContentStrategy {
    private final UserRepository userRepository;
    private final WidgetContentRepository widgetContentRepository;

    @Autowired
    public ActivityContentLoader(UserRepository userRepository, WidgetContentRepository widgetContentRepository) {
        this.userRepository = userRepository;
        this.widgetContentRepository = widgetContentRepository;
    }

    @Override
    public Map<String, ?> loadContent(List<String> contentFields, Map<Filter, Sort> filterSortMapping, WidgetOptions widgetOptions, int limit) {
        Filter filter = WidgetFilterUtil.GROUP_FILTERS.apply(filterSortMapping.keySet());
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"creationDate"});
        Optional.ofNullable(widgetOptions).ifPresent(wo -> this.modifyFilterWithUserCriteria(filter, (WidgetOptions)wo));
        List actionTypes = (List)widgetOptions.getOptions().get("actionType");
        BusinessRule.expect((Object)actionTypes, CollectionUtils::isNotEmpty).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"At least 1 action type should be provided."});
        filter.withCondition((ConvertibleCondition)new FilterCondition(Condition.IN, false, String.join((CharSequence)",", actionTypes), "action"));
        List activityContents = this.widgetContentRepository.activityStatistics(filter, sort, limit);
        return activityContents.isEmpty() ? Collections.emptyMap() : Collections.singletonMap("result", activityContents);
    }

    private void modifyFilterWithUserCriteria(Filter filter, WidgetOptions widgetOptions) {
        Optional.ofNullable(widgetOptions.getOptions()).ifPresent(wo -> Optional.ofNullable(wo.get("user")).ifPresent(users -> {
            if (StringUtils.isNotBlank((CharSequence)String.valueOf(users))) {
                Set<String> usernameCriteria = Arrays.stream(String.valueOf(users).split(",")).map(String::trim).collect(Collectors.toSet());
                usernameCriteria.forEach(username -> this.userRepository.findByLogin(username).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{"User with login " + username + " was not found"})));
                filter.withCondition((ConvertibleCondition)new FilterCondition(Condition.IN, false, String.join((CharSequence)",", usernameCriteria), "user"));
            }
        }));
    }
}

