/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader.materialized;

import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.widget.content.loader.materialized.MaterializedWidgetContentLoader;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.dao.WidgetContentRepository;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class CumulativeTrendChartContentLoaderImpl
implements MaterializedWidgetContentLoader {
    @Autowired
    private WidgetContentRepository widgetContentRepository;

    @Override
    public Map<String, Object> loadContent(Widget widget, MultiValueMap<String, String> params) {
        List content;
        List<String> storedAttributes = WidgetOptionUtil.getListByKey("attributes", widget.getWidgetOptions());
        List providedAttributes = Optional.ofNullable((List)params.get((Object)"attributes")).map(attributes -> attributes.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList())).orElseGet(Collections::emptyList);
        if (providedAttributes.isEmpty()) {
            content = this.widgetContentRepository.cumulativeTrendChart((String)widget.getWidgetOptions().getOptions().get("viewName"), storedAttributes.get(0), storedAttributes.size() > 1 ? storedAttributes.get(1) : null, null);
        } else {
            this.verifyProvidedAttributes(storedAttributes, providedAttributes);
            content = this.widgetContentRepository.cumulativeTrendChart((String)widget.getWidgetOptions().getOptions().get("viewName"), storedAttributes.get(1), null, (String)providedAttributes.get(0));
        }
        return ImmutableMap.builder().put((Object)"result", (Object)content).build();
    }

    private void verifyProvidedAttributes(List<String> storedKeys, List<String> providedAttributes) {
        String[] split = providedAttributes.get(0).split(":");
        BusinessRule.expect((Object)split.length, Predicate.isEqual(2)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"attributes"});
        BusinessRule.expect((Object)storedKeys.contains(split[0]), Predicate.isEqual(true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"attributes"});
        BusinessRule.expect((Object)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{split[1]}), Predicate.isEqual(true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"attributes"});
    }
}

