/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader.materialized.handler;

import com.epam.ta.reportportal.core.events.widget.GenerateWidgetViewEvent;
import com.epam.ta.reportportal.core.widget.content.loader.materialized.handler.MaterializedWidgetStateHandler;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.entity.widget.WidgetState;
import com.epam.ta.reportportal.ws.converter.builders.WidgetBuilder;
import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class CreatedMaterializedWidgetStateHandler
implements MaterializedWidgetStateHandler {
    private final WidgetRepository widgetRepository;
    protected ApplicationEventPublisher eventPublisher;

    public CreatedMaterializedWidgetStateHandler(WidgetRepository widgetRepository, @Qualifier(value="webApplicationContext") ApplicationEventPublisher eventPublisher) {
        this.widgetRepository = widgetRepository;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public Map<String, Object> handleWidgetState(Widget widget, MultiValueMap<String, String> params) {
        this.widgetRepository.save((Object)new WidgetBuilder(widget).addOption("state", WidgetState.RENDERING.getValue()).get());
        this.eventPublisher.publishEvent((Object)new GenerateWidgetViewEvent(widget.getId(), params));
        return Collections.emptyMap();
    }
}

