/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.updater.validator;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.widget.content.updater.validator.WidgetValidatorStrategy;
import com.epam.ta.reportportal.entity.widget.WidgetOptions;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class TopTestCasesContentValidator
implements WidgetValidatorStrategy {
    @Override
    public void validate(List<String> contentFields, Map<Filter, Sort> filterSortMapping, WidgetOptions widgetOptions, int limit) {
        this.validateContentFields(contentFields);
    }

    private void validateContentFields(List<String> contentFields) {
        BusinessRule.expect((Object)CollectionUtils.isNotEmpty(contentFields), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Content fields should not be empty"});
        BusinessRule.expect((Object)contentFields.size(), Predicate.isEqual(1)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Only one content field could be specified."});
    }
}

