/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.entity.enums.ProjectAttributeEnum;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectUtils;
import com.epam.ta.reportportal.job.PageUtil;
import com.epam.ta.reportportal.job.service.LaunchCleanerService;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.math.NumberUtils;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"!unittest"})
public class CleanLaunchesJob
implements Job {
    public static final int DEFAULT_THREAD_COUNT = 5;
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanLaunchesJob.class);
    private final ProjectRepository projectRepository;
    private final LaunchCleanerService launchCleaner;
    @Value(value="5")
    private Integer threadsCount;

    public CleanLaunchesJob(ProjectRepository projectRepository, LaunchCleanerService launchCleaner) {
        this.projectRepository = projectRepository;
        this.launchCleaner = launchCleaner;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        LOGGER.info("Cleaning outdated launches has been started");
        ExecutorService executor = Executors.newFixedThreadPool(Optional.ofNullable(this.threadsCount).orElse(5), new ThreadFactoryBuilder().setNameFormat("clean-launches-job-thread-%d").build());
        PageUtil.iterateOverPages(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"id")}), arg_0 -> ((ProjectRepository)this.projectRepository).findAllIdsAndProjectAttributes(arg_0), projects -> CompletableFuture.allOf((CompletableFuture[])projects.stream().map(project -> {
            AtomicLong removedLaunchesCount = new AtomicLong(0L);
            AtomicLong removedAttachmentsCount = new AtomicLong(0L);
            AtomicLong removedThumbnailsCount = new AtomicLong(0L);
            return CompletableFuture.runAsync(() -> {
                try {
                    this.proceedLaunchesCleaning((Project)project, removedLaunchesCount, removedAttachmentsCount, removedThumbnailsCount);
                }
                catch (Exception e) {
                    LOGGER.error("Cleaning outdated launches for project {} has been failed", (Object)project.getId(), (Object)e);
                }
                if (removedLaunchesCount.get() > 0L || removedAttachmentsCount.get() > 0L || removedThumbnailsCount.get() > 0L) {
                    LOGGER.info("Cleaning outdated launches for project {} has been finished. Total launches removed: {}. Attachments removed: {}. Thumbnails removed: {}", new Object[]{project.getId(), removedLaunchesCount.get(), removedAttachmentsCount.get(), removedThumbnailsCount.get()});
                }
            }, executor);
        }).toArray(CompletableFuture[]::new)).join());
        executor.shutdown();
        LOGGER.info("Cleaning outdated launches has been finished");
    }

    private void proceedLaunchesCleaning(Project project, AtomicLong removedLaunches, AtomicLong removedAttachments, AtomicLong removedThumbnails) {
        ProjectUtils.extractAttributeValue((Project)project, (ProjectAttributeEnum)ProjectAttributeEnum.KEEP_LAUNCHES).map(it -> Duration.ofSeconds(NumberUtils.toLong((String)it, (long)0L))).filter(it -> !it.isZero()).ifPresent(it -> this.launchCleaner.cleanOutdatedLaunches(project, (Duration)it, removedLaunches, removedAttachments, removedThumbnails));
    }
}

