/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.entity.enums.ProjectAttributeEnum;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectUtils;
import com.epam.ta.reportportal.job.PageUtil;
import com.epam.ta.reportportal.job.service.impl.AttachmentCleanerServiceImpl;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAmount;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.math.NumberUtils;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class CleanScreenshotsJob
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanScreenshotsJob.class);
    private final ProjectRepository projectRepository;
    private final AttachmentCleanerServiceImpl attachmentCleanerService;

    @Autowired
    public CleanScreenshotsJob(ProjectRepository projectRepository, AttachmentCleanerServiceImpl attachmentCleanerService) {
        this.projectRepository = projectRepository;
        this.attachmentCleanerService = attachmentCleanerService;
    }

    public void execute(JobExecutionContext context) {
        LOGGER.info("Cleaning outdated screenshots has been started");
        PageUtil.iterateOverPages(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"id")}), arg_0 -> ((ProjectRepository)this.projectRepository).findAllIdsAndProjectAttributes(arg_0), projects -> projects.forEach(project -> {
            AtomicLong attachmentsCount = new AtomicLong(0L);
            AtomicLong thumbnailsCount = new AtomicLong(0L);
            try {
                LOGGER.debug("Cleaning outdated screenshots for project {} has been started", (Object)project.getId());
                this.proceedScreenShotsCleaning((Project)project, attachmentsCount, thumbnailsCount);
            }
            catch (Exception e) {
                LOGGER.error("Cleaning outdated screenshots for project {} has been failed", (Object)project.getId(), (Object)e);
            }
            if (attachmentsCount.get() > 0L || thumbnailsCount.get() > 0L) {
                LOGGER.info("Cleaning outdated screenshots for project {} has been finished. {} attachments and {} thumbnails have been deleted", new Object[]{project.getId(), attachmentsCount.get(), thumbnailsCount.get()});
            }
        }));
        LOGGER.info("Cleaning outdated screenshots has been finished");
    }

    private void proceedScreenShotsCleaning(Project project, AtomicLong attachmentsCount, AtomicLong thumbnailsCount) {
        ProjectUtils.extractAttributeValue((Project)project, (ProjectAttributeEnum)ProjectAttributeEnum.KEEP_SCREENSHOTS).map(it -> Duration.ofSeconds(NumberUtils.toLong((String)it, (long)0L))).filter(it -> !it.isZero()).map(it -> LocalDateTime.now(ZoneOffset.UTC).minus((TemporalAmount)it)).ifPresent(it -> this.attachmentCleanerService.removeProjectAttachments(project, (LocalDateTime)it, attachmentsCount, thumbnailsCount));
    }
}

