/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter;

import com.epam.ta.reportportal.ws.converter.ResourceAssembler;
import com.epam.ta.reportportal.ws.model.Page;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.springframework.data.domain.PageImpl;

public abstract class PagedResourcesAssembler<T, R>
extends ResourceAssembler<T, R> {
    public static <T> Function<org.springframework.data.domain.Page<T>, Page<T>> pageConverter() {
        return page -> new Page((Collection)page.getContent(), new Page.PageMetadata((long)page.getSize(), (long)page.getNumber() + 1L, page.getTotalElements(), (long)page.getTotalPages()));
    }

    public static <T, R> Function<org.springframework.data.domain.Page<T>, Page<R>> pageConverter(Function<T, R> modelConverter) {
        return page -> PagedResourcesAssembler.pageConverter().apply(page.map(modelConverter));
    }

    public static <T, R> Function<org.springframework.data.domain.Page<T>, Page<R>> pageMultiConverter(Function<List<T>, List<R>> modelConverter) {
        return page -> PagedResourcesAssembler.pageConverter().apply((org.springframework.data.domain.Page<PageImpl>)new PageImpl((List)modelConverter.apply(page.getContent()), page.getPageable(), page.getTotalElements()));
    }

    @Deprecated
    public Page<R> toPagedResources(org.springframework.data.domain.Page<T> content) {
        Preconditions.checkNotNull(content, (Object)"Content should be null");
        return new Page(this.toResources(content), new Page.PageMetadata((long)content.getSize(), (long)content.getNumber() + 1L, content.getTotalElements(), (long)content.getTotalPages()));
    }
}

