/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.entity.pattern.PatternTemplate;
import com.epam.ta.reportportal.entity.pattern.PatternTemplateType;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.project.config.pattern.CreatePatternTemplateRQ;
import java.util.function.Supplier;

public class PatternTemplateBuilder
implements Supplier<PatternTemplate> {
    private PatternTemplate patternTemplate = new PatternTemplate();

    public PatternTemplateBuilder withCreateRequest(CreatePatternTemplateRQ createRequest) {
        this.patternTemplate.setTemplateType((PatternTemplateType)PatternTemplateType.fromString((String)createRequest.getType()).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unknown pattern template type - '{}'", (Object[])new Object[]{createRequest.getType()}).get()})));
        this.patternTemplate.setName(createRequest.getName());
        this.patternTemplate.setValue(createRequest.getValue());
        this.patternTemplate.setEnabled(createRequest.getEnabled().booleanValue());
        return this;
    }

    public PatternTemplateBuilder withName(String name) {
        this.patternTemplate.setName(name);
        return this;
    }

    public PatternTemplateBuilder withValue(String value) {
        this.patternTemplate.setValue(value);
        return this;
    }

    public PatternTemplateBuilder withType(PatternTemplateType type) {
        this.patternTemplate.setTemplateType(type);
        return this;
    }

    public PatternTemplateBuilder withEnabled(boolean isEnabled) {
        this.patternTemplate.setEnabled(isEnabled);
        return this;
    }

    public PatternTemplateBuilder withProjectId(Long projectId) {
        this.patternTemplate.setProjectId(projectId);
        return this;
    }

    @Override
    public PatternTemplate get() {
        return this.patternTemplate;
    }
}

