/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.activity.impl;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.CompositeFilter;
import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.querygen.FilterTarget;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.activity.ActivityHandler;
import com.epam.ta.reportportal.dao.ActivityRepository;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.entity.activity.ActivityAction;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.PagedResourcesAssembler;
import com.epam.ta.reportportal.ws.converter.converters.ActivityConverter;
import com.epam.ta.reportportal.ws.model.ActivityResource;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.BooleanUtils;
import org.jooq.Operator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class ActivityHandlerImpl
implements ActivityHandler {
    private final ActivityRepository activityRepository;
    private final TestItemRepository testItemRepository;
    private final LaunchRepository launchRepository;
    private final ProjectRepository projectRepository;

    @Autowired
    public ActivityHandlerImpl(ActivityRepository activityRepository, TestItemRepository testItemRepository, LaunchRepository launchRepository, ProjectRepository projectRepository) {
        this.activityRepository = activityRepository;
        this.testItemRepository = testItemRepository;
        this.launchRepository = launchRepository;
        this.projectRepository = projectRepository;
    }

    @Override
    public Iterable<ActivityResource> getActivitiesHistory(ReportPortalUser.ProjectDetails projectDetails, Filter filter, Queryable predefinedFilter, Pageable pageable) {
        BusinessRule.expect((Object)this.projectRepository.existsById((Object)projectDetails.getProjectId()), BooleanUtils::isTrue).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectDetails.getProjectId()});
        FilterCondition projectCondition = FilterCondition.builder().eq("projectId", String.valueOf(projectDetails.getProjectId())).build();
        Page page = this.activityRepository.findByFilter((Queryable)new CompositeFilter(Operator.AND, new Queryable[]{filter.withCondition((ConvertibleCondition)projectCondition), predefinedFilter}), pageable);
        return (Iterable)PagedResourcesAssembler.pageConverter(ActivityConverter.TO_RESOURCE).apply((Page<Activity>)page);
    }

    @Override
    public ActivityResource getActivity(ReportPortalUser.ProjectDetails projectDetails, Long activityId) {
        Activity activity = (Activity)this.activityRepository.findById((Object)activityId).orElseThrow(() -> new ReportPortalException(ErrorType.ACTIVITY_NOT_FOUND, new Object[]{activityId}));
        BusinessRule.expect((Object)projectDetails.getProjectId(), Predicate.isEqual(activity.getProjectId())).verify(ErrorType.ACCESS_DENIED, new Object[]{Suppliers.formattedSupplier((String)"Activity with id '{}' is not under project with id '{}'", (Object[])new Object[]{activityId, projectDetails.getProjectId()})});
        return ActivityConverter.TO_RESOURCE.apply(activity);
    }

    @Override
    public Iterable<ActivityResource> getItemActivities(ReportPortalUser.ProjectDetails projectDetails, Long itemId, Filter filter, Pageable pageable) {
        TestItem testItem = (TestItem)this.testItemRepository.findById((Object)itemId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{itemId}));
        Launch launch = (Launch)this.launchRepository.findById((Object)testItem.getLaunchId()).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{testItem.getLaunchId()}));
        BusinessRule.expect((Object)projectDetails.getProjectId(), Predicate.isEqual(launch.getProjectId())).verify(ErrorType.ACCESS_DENIED, new Object[]{Suppliers.formattedSupplier((String)"Test item with id '{}' is not under project with id '{}'", (Object[])new Object[]{itemId, projectDetails.getProjectId()})});
        Sort sortByCreationDateDesc = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"creationDate"});
        Filter patternActivityFilter = this.buildPatternMatchedActivityFilter(filter.getTarget(), itemId).withConditions(filter.getFilterConditions());
        filter.withCondition((ConvertibleCondition)FilterCondition.builder().eq("objectId", String.valueOf(itemId)).build()).withCondition((ConvertibleCondition)FilterCondition.builder().withSearchCriteria("entity").withCondition(Condition.IN).withValue(Stream.of(Activity.ActivityEntityType.ITEM, Activity.ActivityEntityType.ITEM_ISSUE, Activity.ActivityEntityType.TICKET).map(Activity.ActivityEntityType::getValue).collect(Collectors.joining(","))).build());
        Page page = this.activityRepository.findByFilter((Queryable)new CompositeFilter(Operator.OR, new Queryable[]{filter, patternActivityFilter}), (Pageable)PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)sortByCreationDateDesc));
        return (Iterable)PagedResourcesAssembler.pageConverter(ActivityConverter.TO_RESOURCE).apply((Page<Activity>)page);
    }

    @Override
    public Iterable<ActivityResource> getItemActivities(ReportPortalUser.ProjectDetails projectDetails, Filter filter, Pageable pageable) {
        BusinessRule.expect((Object)this.projectRepository.existsById((Object)projectDetails.getProjectId()), BooleanUtils::isTrue).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectDetails.getProjectId()});
        filter.withCondition((ConvertibleCondition)FilterCondition.builder().eq("projectId", String.valueOf(projectDetails.getProjectId())).build());
        return (Iterable)PagedResourcesAssembler.pageConverter(ActivityConverter.TO_RESOURCE).apply((Page<Activity>)this.activityRepository.findByFilter((Queryable)filter, pageable));
    }

    private Filter buildPatternMatchedActivityFilter(FilterTarget filterTarget, Long itemId) {
        return Filter.builder().withTarget(filterTarget.getClazz()).withCondition((ConvertibleCondition)FilterCondition.builder().eq("objectId", String.valueOf(itemId)).build()).withCondition((ConvertibleCondition)FilterCondition.builder().eq("entity", Activity.ActivityEntityType.PATTERN.getValue()).build()).withCondition((ConvertibleCondition)FilterCondition.builder().eq("action", ActivityAction.PATTERN_MATCHED.getValue()).build()).build();
    }
}

