/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.client.impl;

import com.epam.ta.reportportal.core.analyzer.auto.client.AnalyzerServiceClient;
import com.epam.ta.reportportal.core.analyzer.auto.client.RabbitMqManagementClient;
import com.epam.ta.reportportal.core.analyzer.auto.client.impl.AnalyzerUtils;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.analyzer.AnalyzedItemRs;
import com.epam.ta.reportportal.ws.model.analyzer.IndexLaunch;
import com.epam.ta.reportportal.ws.model.analyzer.SearchRq;
import com.epam.ta.reportportal.ws.model.analyzer.SearchRs;
import com.rabbitmq.http.client.domain.ExchangeInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AnalyzerServiceClientImpl
implements AnalyzerServiceClient {
    private static final String ANALYZE_ROUTE = "analyze";
    private static final String SEARCH_ROUTE = "search";
    private final RabbitMqManagementClient rabbitMqManagementClient;
    private final RabbitTemplate rabbitTemplate;

    @Autowired
    public AnalyzerServiceClientImpl(RabbitMqManagementClient rabbitMqManagementClient, @Qualifier(value="analyzerRabbitTemplate") RabbitTemplate rabbitTemplate) {
        this.rabbitMqManagementClient = rabbitMqManagementClient;
        this.rabbitTemplate = rabbitTemplate;
    }

    @Override
    public boolean hasClients() {
        return this.rabbitMqManagementClient.getAnalyzerExchangesInfo().size() != 0;
    }

    @Override
    public Map<String, List<AnalyzedItemRs>> analyze(IndexLaunch rq) {
        List<ExchangeInfo> analyzerExchanges = this.rabbitMqManagementClient.getAnalyzerExchangesInfo();
        HashMap<String, List<AnalyzedItemRs>> resultMap = new HashMap<String, List<AnalyzedItemRs>>(analyzerExchanges.size());
        analyzerExchanges.forEach(exchange -> this.analyze(rq, (Map<String, List<AnalyzedItemRs>>)resultMap, (ExchangeInfo)exchange));
        return resultMap;
    }

    @Override
    public List<SearchRs> searchLogs(SearchRq rq) {
        List<ExchangeInfo> analyzerExchanges = this.rabbitMqManagementClient.getAnalyzerExchangesInfo().stream().filter(AnalyzerUtils.DOES_SUPPORT_SEARCH).collect(Collectors.toList());
        return this.search(rq, analyzerExchanges);
    }

    private List<SearchRs> search(SearchRq rq, List<ExchangeInfo> analyzerExchanges) {
        if (CollectionUtils.isEmpty(analyzerExchanges)) {
            throw new ReportPortalException(ErrorType.UNABLE_INTERACT_WITH_INTEGRATION, new Object[]{"There are no analyzer services with search logs support deployed."});
        }
        ExchangeInfo prioritizedExchange = Collections.min(analyzerExchanges, Comparator.comparingInt(AnalyzerUtils.EXCHANGE_PRIORITY));
        return (List)this.rabbitTemplate.convertSendAndReceiveAsType(prioritizedExchange.getName(), SEARCH_ROUTE, (Object)rq, (ParameterizedTypeReference)new ParameterizedTypeReference<List<SearchRs>>(){});
    }

    private void analyze(IndexLaunch rq, Map<String, List<AnalyzedItemRs>> resultMap, ExchangeInfo exchangeInfo) {
        List result = (List)this.rabbitTemplate.convertSendAndReceiveAsType(exchangeInfo.getName(), ANALYZE_ROUTE, Collections.singletonList(rq), (ParameterizedTypeReference)new ParameterizedTypeReference<List<AnalyzedItemRs>>(){});
        if (!CollectionUtils.isEmpty((Collection)result)) {
            resultMap.put(exchangeInfo.getArguments().getOrDefault("analyzer", exchangeInfo.getName()), result);
            this.removeAnalyzedFromRq(rq, result);
        }
    }

    private void removeAnalyzedFromRq(IndexLaunch rq, List<AnalyzedItemRs> analyzed) {
        List analyzedItemIds = analyzed.stream().map(AnalyzedItemRs::getItemId).collect(Collectors.toList());
        rq.getTestItems().removeIf(it -> analyzedItemIds.contains(it.getTestItemId()));
    }
}

