/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.client.impl;

import com.epam.ta.reportportal.core.analyzer.auto.client.IndexerServiceClient;
import com.epam.ta.reportportal.core.analyzer.auto.client.RabbitMqManagementClient;
import com.epam.ta.reportportal.core.analyzer.auto.client.impl.AnalyzerUtils;
import com.epam.ta.reportportal.ws.model.analyzer.CleanIndexRq;
import com.epam.ta.reportportal.ws.model.analyzer.IndexLaunch;
import com.epam.ta.reportportal.ws.model.analyzer.IndexRs;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;

@Service
public class IndexerServiceClientImpl
implements IndexerServiceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexerServiceClient.class);
    private static final String INDEX_ROUTE = "index";
    private static final String NAMESPACE_FINDER_ROUTE = "namespace_finder";
    private static final String DELETE_ROUTE = "delete";
    private static final String CLEAN_ROUTE = "clean";
    private static final Integer DELETE_INDEX_SUCCESS_CODE = 1;
    private final RabbitMqManagementClient rabbitMqManagementClient;
    private final RabbitTemplate rabbitTemplate;

    public IndexerServiceClientImpl(RabbitMqManagementClient rabbitMqManagementClient, @Qualifier(value="analyzerRabbitTemplate") RabbitTemplate rabbitTemplate) {
        this.rabbitMqManagementClient = rabbitMqManagementClient;
        this.rabbitTemplate = rabbitTemplate;
    }

    @Override
    public Long index(List<IndexLaunch> rq) {
        return this.rabbitMqManagementClient.getAnalyzerExchangesInfo().stream().filter(AnalyzerUtils.DOES_SUPPORT_INDEX).map(exchange -> {
            this.rabbitTemplate.convertAndSend(exchange.getName(), NAMESPACE_FINDER_ROUTE, (Object)rq);
            return (IndexRs)this.rabbitTemplate.convertSendAndReceiveAsType(exchange.getName(), INDEX_ROUTE, (Object)rq, (ParameterizedTypeReference)new ParameterizedTypeReference<IndexRs>(){});
        }).mapToLong(it -> {
            if (Objects.nonNull(it)) {
                return it.getTook();
            }
            return 0L;
        }).sum();
    }

    @Override
    public Long cleanIndex(Long index, List<Long> ids) {
        Map<Integer, Long> priorityToCleanedLogsCountMapping = this.rabbitMqManagementClient.getAnalyzerExchangesInfo().stream().collect(Collectors.toMap(AnalyzerUtils.EXCHANGE_PRIORITY::applyAsInt, exchange -> (Long)this.rabbitTemplate.convertSendAndReceiveAsType(exchange.getName(), CLEAN_ROUTE, (Object)new CleanIndexRq(index, ids), (ParameterizedTypeReference)new ParameterizedTypeReference<Long>(){})));
        return (Long)priorityToCleanedLogsCountMapping.entrySet().stream().min(Map.Entry.comparingByKey()).orElseGet(() -> new AbstractMap.SimpleEntry<Integer, Long>(0, 0L)).getValue();
    }

    @Override
    public void deleteIndex(Long index) {
        this.rabbitMqManagementClient.getAnalyzerExchangesInfo().stream().map(exchange -> (Integer)this.rabbitTemplate.convertSendAndReceiveAsType(exchange.getName(), DELETE_ROUTE, (Object)index, (ParameterizedTypeReference)new ParameterizedTypeReference<Integer>(){})).forEach(it -> {
            if (DELETE_INDEX_SUCCESS_CODE.equals(it)) {
                LOGGER.info("Successfully deleted index '{}'", (Object)index);
            } else {
                LOGGER.error("Error deleting index '{}'", (Object)index);
            }
        });
    }
}

