/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.auto.impl;

import com.epam.ta.reportportal.core.analyzer.auto.LogIndexer;
import com.epam.ta.reportportal.core.analyzer.auto.client.IndexerServiceClient;
import com.epam.ta.reportportal.core.analyzer.auto.impl.LaunchPreparerService;
import com.epam.ta.reportportal.core.analyzer.auto.indexer.IndexerStatusCache;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.analyzer.IndexLaunch;
import com.epam.ta.reportportal.ws.model.project.AnalyzerConfig;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class LogIndexerService
implements LogIndexer {
    private static Logger LOGGER = LoggerFactory.getLogger(LogIndexerService.class);
    private final LaunchRepository launchRepository;
    private final TestItemRepository testItemRepository;
    private final IndexerServiceClient indexerServiceClient;
    private final LaunchPreparerService launchPreparerService;
    private final IndexerStatusCache indexerStatusCache;

    @Autowired
    public LogIndexerService(LaunchRepository launchRepository, TestItemRepository testItemRepository, IndexerServiceClient indexerServiceClient, LaunchPreparerService launchPreparerService, IndexerStatusCache indexerStatusCache) {
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
        this.indexerServiceClient = indexerServiceClient;
        this.launchPreparerService = launchPreparerService;
        this.indexerStatusCache = indexerStatusCache;
    }

    @Override
    @Transactional(readOnly=true)
    public CompletableFuture<Long> indexLaunchesLogs(Long projectId, List<Long> launchIds, AnalyzerConfig analyzerConfig) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.indexerStatusCache.indexingStarted(projectId);
                List<IndexLaunch> indexLaunches = this.prepareLaunches(this.launchRepository.findAllById((Iterable)launchIds), analyzerConfig);
                LOGGER.info("Start indexing for {} launches", (Object)indexLaunches.size());
                Long indexed = this.indexerServiceClient.index(indexLaunches);
                LOGGER.info("Indexed {} logs", (Object)indexed);
                Long l = indexed;
                return l;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new ReportPortalException(e.getMessage());
            }
            finally {
                this.indexerStatusCache.indexingFinished(projectId);
            }
        });
    }

    @Override
    @Transactional(readOnly=true)
    public CompletableFuture<Long> indexLaunchLogs(Long projectId, Long launchId, AnalyzerConfig analyzerConfig) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.indexerStatusCache.indexingStarted(projectId);
                Launch launch = (Launch)this.launchRepository.findById((Object)launchId).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId}));
                Optional<IndexLaunch> indexLaunch = this.launchPreparerService.prepare(launch, this.testItemRepository.findTestItemsByLaunchId(launch.getId()), analyzerConfig);
                Long l = indexLaunch.map(it -> {
                    LOGGER.info("Start indexing for {} launches", (Object)1);
                    Long indexed = this.indexerServiceClient.index(Lists.newArrayList((Object[])new IndexLaunch[]{it}));
                    LOGGER.info("Indexed {} logs", (Object)indexed);
                    return indexed;
                }).orElse(0L);
                return l;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new ReportPortalException(e.getMessage());
            }
            finally {
                this.indexerStatusCache.indexingFinished(projectId);
            }
        });
    }

    @Override
    @Transactional(readOnly=true)
    public Long indexItemsLogs(Long projectId, Long launchId, List<Long> itemIds, AnalyzerConfig analyzerConfig) {
        try {
            this.indexerStatusCache.indexingStarted(projectId);
            Launch launch = (Launch)this.launchRepository.findById((Object)launchId).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId}));
            Long l = this.launchPreparerService.prepare(launch, this.testItemRepository.findAllById(itemIds), analyzerConfig).map(it -> this.indexerServiceClient.index(Lists.newArrayList((Object[])new IndexLaunch[]{it}))).orElse(0L);
            return l;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ReportPortalException(e.getMessage());
        }
        finally {
            this.indexerStatusCache.indexingFinished(projectId);
        }
    }

    @Override
    public CompletableFuture<Long> indexPreparedLogs(Long projectId, IndexLaunch indexLaunch) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.indexerStatusCache.indexingStarted(projectId);
                Long l = this.indexerServiceClient.index(Lists.newArrayList((Object[])new IndexLaunch[]{indexLaunch}));
                return l;
            }
            catch (Exception ex) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
                throw new ReportPortalException(ex.getMessage());
            }
            finally {
                this.indexerStatusCache.indexingFinished(projectId);
            }
        });
    }

    @Override
    public void deleteIndex(Long project) {
        this.indexerServiceClient.deleteIndex(project);
    }

    @Override
    public CompletableFuture<Long> cleanIndex(Long index, List<Long> ids) {
        return CollectionUtils.isEmpty(ids) ? CompletableFuture.completedFuture(0L) : CompletableFuture.supplyAsync(() -> this.indexerServiceClient.cleanIndex(index, ids));
    }

    private List<IndexLaunch> prepareLaunches(List<Launch> launches, AnalyzerConfig analyzerConfig) {
        return launches.stream().filter(it -> this.testItemRepository.hasItemsWithIssueByLaunch(it.getId())).map(it -> this.launchPreparerService.prepare((Launch)it, this.testItemRepository.findTestItemsByLaunchId(it.getId()), analyzerConfig)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

