/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.analyzer.pattern.selector.impl;

import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.analyzer.pattern.selector.PatternAnalysisSelector;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.LogLevel;
import com.epam.ta.reportportal.entity.pattern.PatternTemplate;
import com.epam.ta.reportportal.entity.pattern.PatternTemplateTestItemPojo;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StringPartPatternAnalysisSelector
implements PatternAnalysisSelector {
    private final TestItemRepository testItemRepository;

    @Autowired
    public StringPartPatternAnalysisSelector(TestItemRepository testItemRepository) {
        this.testItemRepository = testItemRepository;
    }

    @Override
    public List<PatternTemplateTestItemPojo> selectItemsByPattern(Queryable filter, PatternTemplate patternTemplate) {
        return this.testItemRepository.selectIdsByStringPatternMatchedLogMessage(filter, Integer.valueOf(LogLevel.ERROR.toInt()), patternTemplate.getValue()).stream().map(itemId -> new PatternTemplateTestItemPojo(patternTemplate.getId(), itemId)).collect(Collectors.toList());
    }
}

