/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.bts.handler.impl;

import com.epam.reportportal.extension.bugtracking.BtsExtension;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.bts.handler.GetTicketHandler;
import com.epam.ta.reportportal.core.integration.GetIntegrationHandler;
import com.epam.ta.reportportal.core.plugin.PluginBox;
import com.epam.ta.reportportal.entity.integration.Integration;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.externalsystem.PostFormField;
import com.epam.ta.reportportal.ws.model.externalsystem.Ticket;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetTicketHandlerImpl
implements GetTicketHandler {
    private final PluginBox pluginBox;
    private final GetIntegrationHandler getIntegrationHandler;

    @Autowired
    public GetTicketHandlerImpl(PluginBox pluginBox, GetIntegrationHandler getIntegrationHandler) {
        this.pluginBox = pluginBox;
        this.getIntegrationHandler = getIntegrationHandler;
    }

    @Override
    public Ticket getTicket(String ticketId, String url, String btsProject, ReportPortalUser.ProjectDetails projectDetails) {
        Integration integration = this.getIntegrationHandler.getEnabledBtsIntegration(projectDetails, url, btsProject);
        return (Ticket)this.getBtsExtension(integration).getTicket(ticketId, integration).orElseThrow(() -> new ReportPortalException(ErrorType.TICKET_NOT_FOUND, new Object[]{ticketId}));
    }

    @Override
    public List<PostFormField> getSubmitTicketFields(String ticketType, Long integrationId, ReportPortalUser.ProjectDetails projectDetails) {
        Integration integration = this.getIntegrationHandler.getEnabledBtsIntegration(projectDetails, integrationId);
        return this.getBtsExtension(integration).getTicketFields(ticketType, integration);
    }

    @Override
    public List<PostFormField> getSubmitTicketFields(String ticketType, Long integrationId) {
        Integration integration = this.getIntegrationHandler.getEnabledBtsIntegration(integrationId);
        return this.getBtsExtension(integration).getTicketFields(ticketType, integration);
    }

    @Override
    public List<String> getAllowableIssueTypes(Long integrationId, ReportPortalUser.ProjectDetails projectDetails) {
        Integration integration = this.getIntegrationHandler.getEnabledBtsIntegration(projectDetails, integrationId);
        return this.getBtsExtension(integration).getIssueTypes(integration);
    }

    @Override
    public List<String> getAllowableIssueTypes(Long integrationId) {
        Integration integration = this.getIntegrationHandler.getEnabledBtsIntegration(integrationId);
        return this.getBtsExtension(integration).getIssueTypes(integration);
    }

    private BtsExtension getBtsExtension(Integration integration) {
        return this.pluginBox.getInstance(integration.getType().getName(), BtsExtension.class).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"BugTracking plugin for {} isn't installed", (Object[])new Object[]{integration.getType().getName()}).get()}));
    }
}

