/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.activity;

import com.epam.ta.reportportal.core.events.ActivityEvent;
import com.epam.ta.reportportal.core.events.activity.AroundEvent;
import com.epam.ta.reportportal.entity.activity.Activity;
import com.epam.ta.reportportal.entity.activity.ActivityAction;
import com.epam.ta.reportportal.ws.converter.builders.ActivityBuilder;
import com.epam.ta.reportportal.ws.model.activity.TestItemActivityResource;
import com.google.common.base.Strings;
import java.util.Arrays;

public class LinkTicketEvent
extends AroundEvent<TestItemActivityResource>
implements ActivityEvent {
    private ActivityAction activityAction;

    public LinkTicketEvent() {
    }

    public LinkTicketEvent(TestItemActivityResource before, TestItemActivityResource after, Long userId, String userLogin, ActivityAction activityAction) {
        super(userId, userLogin, before, after);
        if (!Arrays.asList(ActivityAction.LINK_ISSUE_AA, ActivityAction.LINK_ISSUE).contains(activityAction)) {
            throw new IllegalArgumentException("Activity action '" + activityAction + "' is not supported");
        }
        this.activityAction = activityAction;
    }

    public LinkTicketEvent(TestItemActivityResource before, TestItemActivityResource after, String userLogin, ActivityAction activityAction) {
        super(null, userLogin, before, after);
        if (!Arrays.asList(ActivityAction.LINK_ISSUE_AA, ActivityAction.LINK_ISSUE).contains(activityAction)) {
            throw new IllegalArgumentException("Activity action '" + activityAction + "' is not supported");
        }
        this.activityAction = activityAction;
    }

    public ActivityAction getActivityAction() {
        return this.activityAction;
    }

    public void setActivityAction(ActivityAction activityAction) {
        this.activityAction = activityAction;
    }

    @Override
    public Activity toActivity() {
        ActivityBuilder builder = new ActivityBuilder().addCreatedNow().addAction(this.activityAction).addActivityEntityType(Activity.ActivityEntityType.TICKET).addUserId(this.getUserId()).addUserName(this.getUserLogin()).addObjectId(((TestItemActivityResource)this.getAfter()).getId()).addObjectName(((TestItemActivityResource)this.getAfter()).getName()).addProjectId(((TestItemActivityResource)this.getAfter()).getProjectId());
        if (this.getAfter() != null) {
            String oldValue = ((TestItemActivityResource)this.getBefore()).getTickets();
            String newValue = ((TestItemActivityResource)this.getAfter()).getTickets();
            if (Strings.isNullOrEmpty((String)oldValue) && newValue.isEmpty() || oldValue.equalsIgnoreCase(newValue)) {
                return null;
            }
            if (!oldValue.isEmpty() && !newValue.isEmpty() || !oldValue.equalsIgnoreCase(newValue)) {
                if (oldValue.length() > newValue.length()) {
                    builder.addAction(ActivityAction.UNLINK_ISSUE);
                }
                builder.addHistoryField("ticketId", oldValue, newValue);
            }
        }
        return builder.get();
    }
}

