/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.events.handler;

import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.events.widget.GenerateWidgetViewEvent;
import com.epam.ta.reportportal.core.widget.content.BuildFilterStrategy;
import com.epam.ta.reportportal.core.widget.content.loader.materialized.generator.ViewGenerator;
import com.epam.ta.reportportal.core.widget.util.WidgetFilterUtil;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.entity.widget.WidgetType;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.domain.Sort;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.event.TransactionalEventListener;

@Service
public class GenerateWidgetViewEventHandler {
    private static final String VIEW_PREFIX = "widget";
    private static final String NAME_SEPARATOR = "_";
    private final WidgetRepository widgetRepository;
    private final Map<WidgetType, BuildFilterStrategy> buildFilterStrategyMapping;
    private final TaskExecutor widgetViewExecutor;
    private final Map<WidgetType, ViewGenerator> viewGeneratorMapping;

    @Autowired
    public GenerateWidgetViewEventHandler(WidgetRepository widgetRepository, @Qualifier(value="buildFilterStrategy") Map<WidgetType, BuildFilterStrategy> buildFilterStrategyMapping, @Qualifier(value="widgetViewExecutor") TaskExecutor widgetViewExecutor, @Qualifier(value="viewGeneratorMapping") Map<WidgetType, ViewGenerator> viewGeneratorMapping) {
        this.widgetRepository = widgetRepository;
        this.buildFilterStrategyMapping = buildFilterStrategyMapping;
        this.widgetViewExecutor = widgetViewExecutor;
        this.viewGeneratorMapping = viewGeneratorMapping;
    }

    @Async
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @TransactionalEventListener
    public void onApplicationEvent(GenerateWidgetViewEvent event) {
        this.widgetRepository.findById((Object)event.getWidgetId()).ifPresent(widget -> {
            WidgetType widgetType = (WidgetType)WidgetType.findByName((String)widget.getWidgetType()).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_TO_CREATE_WIDGET, new Object[]{Suppliers.formattedSupplier((String)"Unsupported widget type '{}'", (Object[])new Object[]{widget.getWidgetType()})}));
            Map<Filter, Sort> filterSortMapping = this.buildFilterStrategyMapping.get(widgetType).buildFilter((Widget)widget);
            Filter launchesFilter = WidgetFilterUtil.GROUP_FILTERS.apply(filterSortMapping.keySet());
            Sort launchesSort = WidgetFilterUtil.GROUP_SORTS.apply(filterSortMapping.values());
            Optional.ofNullable(this.viewGeneratorMapping.get(widgetType)).ifPresent(viewGenerator -> this.widgetViewExecutor.execute(() -> viewGenerator.generate(BooleanUtils.toBoolean((String)((String)event.getParams().getFirst((Object)"refresh"))), this.generateViewName((Widget)widget), (Widget)widget, launchesFilter, launchesSort, event.getParams())));
        });
    }

    private String generateViewName(Widget widget) {
        return String.join((CharSequence)NAME_SEPARATOR, VIEW_PREFIX, String.valueOf(widget.getProject().getId()), String.valueOf(widget.getId()));
    }
}

