/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.imprt.impl.junit;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.imprt.impl.ParseResults;
import com.epam.ta.reportportal.core.imprt.impl.junit.XunitImportHandler;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

@Component
@Scope(value="prototype")
public class XunitParseJob
implements Callable<ParseResults> {
    @Autowired
    private XunitImportHandler handler;
    private InputStream xmlInputStream;

    @Override
    public ParseResults call() {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser saxParser = spf.newSAXParser();
            XMLReader reader = saxParser.getXMLReader();
            spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            spf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            saxParser.parse(this.xmlInputStream, (DefaultHandler)this.handler);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ReportPortalException(ErrorType.PARSING_XML_ERROR, new Object[]{e.getMessage()});
        }
        return new ParseResults(this.handler.getStartSuiteTime(), this.handler.getCommonDuration());
    }

    public XunitParseJob withParameters(ReportPortalUser.ProjectDetails projectDetails, String launchId, ReportPortalUser user, InputStream xmlInputStream) {
        this.xmlInputStream = xmlInputStream;
        this.handler = this.handler.withParameters(projectDetails, launchId, user);
        return this;
    }
}

