/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.history.provider.impl;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.item.TestItemService;
import com.epam.ta.reportportal.core.item.impl.LaunchAccessValidator;
import com.epam.ta.reportportal.core.item.impl.history.param.HistoryRequestParams;
import com.epam.ta.reportportal.core.item.impl.history.provider.HistoryProvider;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.item.history.TestItemHistory;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.jooq.Operator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class TestItemBaselineHistoryProvider
implements HistoryProvider {
    private final TestItemService testItemService;
    private final LaunchAccessValidator launchAccessValidator;
    private final TestItemRepository testItemRepository;

    @Autowired
    public TestItemBaselineHistoryProvider(TestItemService testItemService, LaunchAccessValidator launchAccessValidator, TestItemRepository testItemRepository) {
        this.testItemService = testItemService;
        this.launchAccessValidator = launchAccessValidator;
        this.testItemRepository = testItemRepository;
    }

    @Override
    public Page<TestItemHistory> provide(Queryable filter, Pageable pageable, HistoryRequestParams historyRequestParams, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, boolean usingHash) {
        return historyRequestParams.getParentId().map(parentId -> this.loadHistory(this.resolveFilter(filter, (Long)parentId), pageable, (Long)parentId, historyRequestParams, projectDetails, user, usingHash)).orElseGet(() -> historyRequestParams.getItemId().map(itemId -> this.loadHistory(filter, pageable, (Long)itemId, historyRequestParams, projectDetails, user, usingHash)).orElseGet(() -> Page.empty((Pageable)pageable)));
    }

    private Queryable resolveFilter(Queryable filter, Long parentId) {
        return filter.getFilterConditions().stream().flatMap(c -> c.getAllConditions().stream()).filter(c -> "hasChildren".equalsIgnoreCase(c.getSearchCriteria()) && !BooleanUtils.toBoolean((String)c.getValue())).findFirst().map(notHasChildren -> this.updateParentFilter(filter, parentId)).orElse(filter);
    }

    private Queryable updateParentFilter(Queryable parentFilter, Long parentId) {
        TestItem parent = (TestItem)this.testItemRepository.findById((Object)parentId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{parentId}));
        List resultConditions = parentFilter.getFilterConditions().stream().filter(c -> c.getAllConditions().stream().noneMatch(fc -> "parentId".equalsIgnoreCase(fc.getSearchCriteria()) && Condition.EQUALS.equals((Object)fc.getCondition()))).collect(Collectors.toList());
        resultConditions.add(FilterCondition.builder().withOperator(Operator.AND).withCondition(Condition.UNDER).withSearchCriteria("path").withValue(String.valueOf(parent.getPath())).build());
        return new Filter(parentFilter.getTarget().getClazz(), resultConditions);
    }

    private Page<TestItemHistory> loadHistory(Queryable filter, Pageable pageable, Long itemId, HistoryRequestParams historyRequestParams, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, boolean usingHash) {
        TestItem testItem = (TestItem)this.testItemRepository.findById((Object)itemId).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{itemId}));
        Launch launch = this.testItemService.getEffectiveLaunch(testItem);
        this.launchAccessValidator.validate(launch.getId(), projectDetails, user);
        return historyRequestParams.getHistoryType().filter(HistoryRequestParams.HistoryTypeEnum.LINE::equals).map(type -> this.testItemRepository.loadItemsHistoryPage(filter, pageable, projectDetails.getProjectId(), launch.getName(), historyRequestParams.getHistoryDepth(), usingHash)).orElseGet(() -> this.testItemRepository.loadItemsHistoryPage(filter, pageable, projectDetails.getProjectId(), historyRequestParams.getHistoryDepth(), usingHash));
    }
}

