/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.retry;

import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.events.item.ItemRetryEvent;
import com.epam.ta.reportportal.core.item.impl.retry.RetriesHandler;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Objects;
import org.springframework.context.ApplicationEventPublisher;

public abstract class AbstractRetriesHandler
implements RetriesHandler {
    protected final TestItemRepository testItemRepository;
    private final LaunchRepository launchRepository;
    private final ApplicationEventPublisher eventPublisher;

    public AbstractRetriesHandler(TestItemRepository testItemRepository, LaunchRepository launchRepository, ApplicationEventPublisher eventPublisher) {
        this.testItemRepository = testItemRepository;
        this.launchRepository = launchRepository;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void handleRetries(Launch launch, TestItem newRetryParent, Long previousParent) {
        this.handleRetries(launch, previousParent, newRetryParent);
        this.eventPublisher.publishEvent((Object)ItemRetryEvent.of(launch.getProjectId(), launch.getId(), newRetryParent.getItemId()));
    }

    private void handleRetries(Launch launch, Long retryParent, TestItem newRetryParent) {
        this.validateNewParent(retryParent, newRetryParent);
        this.testItemRepository.handleRetry(retryParent, newRetryParent.getItemId());
        this.updateLaunchRetriesState(launch);
    }

    private void validateNewParent(Long prevRetryParent, TestItem newRetryParent) {
        BusinessRule.expect((Object)newRetryParent, i -> !i.getItemId().equals(prevRetryParent)).verify(ErrorType.RETRIES_HANDLER_ERROR, new Object[]{"Previous and new parent 'id' should not be equal"});
        BusinessRule.expect((Object)newRetryParent, i -> Objects.isNull(i.getRetryOf())).verify(ErrorType.RETRIES_HANDLER_ERROR, new Object[]{"Parent item should not be a retry"});
    }

    private void updateLaunchRetriesState(Launch launch) {
        if (!launch.isHasRetries()) {
            launch.setHasRetries(this.launchRepository.hasRetries(launch.getId()));
        }
    }
}

