/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.impl.retry;

import com.epam.ta.reportportal.core.item.identity.IdentityUtil;
import com.epam.ta.reportportal.core.item.identity.TestCaseHashGenerator;
import com.epam.ta.reportportal.core.item.impl.retry.AbstractRetriesHandler;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import java.util.Objects;
import java.util.Optional;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service(value="testCaseHashRetriesHandler")
public class TestCaseHashRetriesHandler
extends AbstractRetriesHandler {
    private final TestCaseHashGenerator testCaseHashGenerator;

    public TestCaseHashRetriesHandler(TestItemRepository testItemRepository, LaunchRepository launchRepository, ApplicationEventPublisher eventPublisher, TestCaseHashGenerator testCaseHashGenerator) {
        super(testItemRepository, launchRepository, eventPublisher);
        this.testCaseHashGenerator = testCaseHashGenerator;
    }

    @Override
    public Optional<Long> findPreviousRetry(Launch launch, TestItem newItem, TestItem parentItem) {
        if (Objects.isNull(newItem.getTestCaseId())) {
            newItem.setTestCaseHash(this.testCaseHashGenerator.generate(newItem, IdentityUtil.getItemTreeIds(parentItem), launch.getProjectId()));
        }
        return this.testItemRepository.findLatestIdByTestCaseHashAndLaunchIdAndParentId(newItem.getTestCaseHash(), launch.getId(), parentItem.getItemId());
    }
}

