/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.log;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.entity.enums.LogLevel;
import com.epam.ta.reportportal.ws.model.EntryCreatedAsyncRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.web.multipart.MultipartFile;

public interface CreateLogHandler {
    @Nonnull
    public EntryCreatedAsyncRS createLog(@Nonnull SaveLogRQ var1, @Nullable MultipartFile var2, @Nullable ReportPortalUser.ProjectDetails var3);

    default public void validate(SaveLogRQ saveLogRQ) {
        BusinessRule.expect((Object)LogLevel.toCustomLogLevel((String)saveLogRQ.getLevel()), (Predicate)Predicates.notNull()).verify(ErrorType.BAD_SAVE_LOG_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Cannot convert '{}' to valid 'LogLevel'", (Object[])new Object[]{saveLogRQ.getLevel()})});
    }
}

