/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.content.remover.impl;

import com.epam.ta.reportportal.core.project.content.remover.ProjectContentRemover;
import com.epam.ta.reportportal.core.widget.content.remover.WidgetContentRemover;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.entity.widget.WidgetType;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectContentRemoverImpl
implements ProjectContentRemover {
    private final WidgetRepository widgetRepository;
    private final List<WidgetContentRemover> widgetContentRemovers;

    @Autowired
    public ProjectContentRemoverImpl(WidgetRepository widgetRepository, List<WidgetContentRemover> widgetContentRemovers) {
        this.widgetRepository = widgetRepository;
        this.widgetContentRemovers = widgetContentRemovers;
    }

    @Override
    public void removeContent(Project project) {
        List widgets = this.widgetRepository.findAllByProjectIdAndWidgetTypeIn(project.getId(), Collections.singletonList(WidgetType.COMPONENT_HEALTH_CHECK_TABLE.getType()));
        widgets.forEach(w -> this.widgetContentRemovers.forEach(remover -> remover.removeContent((Widget)w)));
    }
}

