/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.user.content.remover.impl;

import com.epam.ta.reportportal.core.user.content.remover.UserContentRemover;
import com.epam.ta.reportportal.core.widget.content.remover.WidgetContentRemover;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.entity.widget.WidgetType;
import java.util.Collections;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class UserContentRemoverImpl
implements UserContentRemover {
    private final WidgetRepository widgetRepository;
    private final List<WidgetContentRemover> widgetContentRemovers;

    public UserContentRemoverImpl(WidgetRepository widgetRepository, List<WidgetContentRemover> widgetContentRemovers) {
        this.widgetRepository = widgetRepository;
        this.widgetContentRemovers = widgetContentRemovers;
    }

    @Override
    public void removeContent(User user) {
        List widgets = this.widgetRepository.findAllByOwnerAndWidgetTypeIn(user.getLogin(), Collections.singletonList(WidgetType.COMPONENT_HEALTH_CHECK_TABLE.getType()));
        widgets.forEach(w -> this.widgetContentRemovers.forEach(remover -> remover.removeContent((Widget)w)));
    }
}

