/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.user.impl;

import com.epam.ta.reportportal.binary.UserBinaryDataService;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.user.EditUserHandler;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.entity.enums.ImageFormat;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectUtils;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.entity.user.UserRole;
import com.epam.ta.reportportal.entity.user.UserType;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.util.UserUtils;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.user.ChangePasswordRQ;
import com.epam.ta.reportportal.ws.model.user.EditUserRQ;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.activation.MimetypesFileTypeMap;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class EditUserHandlerImpl
implements EditUserHandler {
    private final UserRepository userRepository;
    private final ProjectRepository projectRepository;
    private final UserBinaryDataService userBinaryDataService;
    private final PasswordEncoder passwordEncoder;
    private final MimetypesFileTypeMap mimetypesFileTypeMap;
    private final AutoDetectParser autoDetectParser;

    @Autowired
    public EditUserHandlerImpl(PasswordEncoder passwordEncoder, UserRepository userRepository, ProjectRepository projectRepository, UserBinaryDataService userBinaryDataService, MimetypesFileTypeMap mimetypesFileTypeMap, AutoDetectParser autoDetectParser) {
        this.passwordEncoder = passwordEncoder;
        this.userRepository = userRepository;
        this.projectRepository = projectRepository;
        this.userBinaryDataService = userBinaryDataService;
        this.mimetypesFileTypeMap = mimetypesFileTypeMap;
        this.autoDetectParser = autoDetectParser;
    }

    @Override
    public OperationCompletionRS editUser(String username, EditUserRQ editUserRQ, ReportPortalUser editor) {
        User user = (User)this.userRepository.findByLogin(username).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{username}));
        if (null != editUserRQ.getRole()) {
            BusinessRule.expect((Object)editor.getUserRole(), (Predicate)Predicates.equalTo((Object)UserRole.ADMINISTRATOR)).verify(ErrorType.ACCESS_DENIED, new Object[]{"Current Account Role can't update roles."});
            BusinessRule.expect((Object)user, u -> !u.getLogin().equalsIgnoreCase(editor.getUsername())).verify(ErrorType.ACCESS_DENIED, new Object[]{"You cannot update your role."});
            UserRole newRole = (UserRole)UserRole.findByName((String)editUserRQ.getRole()).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Incorrect specified Account Role parameter."}));
            user.setRole(newRole);
        }
        if (null != editUserRQ.getEmail() && !editUserRQ.getEmail().equals(user.getEmail())) {
            String updEmail = editUserRQ.getEmail().toLowerCase().trim();
            BusinessRule.expect((Object)user.getUserType(), (Predicate)Predicates.equalTo((Object)UserType.INTERNAL)).verify(ErrorType.ACCESS_DENIED, new Object[]{"Unable to change email for external user"});
            BusinessRule.expect((Object)UserUtils.isEmailValid((String)updEmail), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{" wrong email: " + updEmail});
            Optional byEmail = this.userRepository.findByEmail(updEmail);
            BusinessRule.expect((Object)byEmail, (Predicate)Predicates.not(Optional::isPresent)).verify(ErrorType.USER_ALREADY_EXISTS, new Object[]{updEmail});
            List userProjects = this.projectRepository.findUserProjects(username);
            userProjects.forEach(project -> ProjectUtils.updateProjectRecipients((String)user.getEmail(), (String)updEmail, (Project)project));
            user.setEmail(updEmail);
            try {
                this.projectRepository.saveAll((Iterable)userProjects);
            }
            catch (Exception exp) {
                throw new ReportPortalException("PROJECT update exception while USER editing.", (Throwable)exp);
            }
        }
        if (null != editUserRQ.getFullName()) {
            BusinessRule.expect((Object)user.getUserType(), (Predicate)Predicates.equalTo((Object)UserType.INTERNAL)).verify(ErrorType.ACCESS_DENIED, new Object[]{"Unable to change full name for external user"});
            user.setFullName(editUserRQ.getFullName());
        }
        try {
            this.userRepository.save((Object)user);
        }
        catch (Exception exp) {
            throw new ReportPortalException("Error while User editing.", (Throwable)exp);
        }
        return new OperationCompletionRS("User with login = '" + user.getLogin() + "' successfully updated");
    }

    @Override
    public OperationCompletionRS uploadPhoto(String username, MultipartFile file) {
        User user = (User)this.userRepository.findByLogin(username).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{username}));
        this.validatePhoto(file);
        this.userBinaryDataService.saveUserPhoto(user, file);
        return new OperationCompletionRS("Profile photo has been uploaded successfully");
    }

    @Override
    public OperationCompletionRS deletePhoto(String login) {
        User user = (User)this.userRepository.findByLogin(login).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{login}));
        BusinessRule.expect((Object)user.getUserType(), (Predicate)Predicates.equalTo((Object)UserType.INTERNAL)).verify(ErrorType.ACCESS_DENIED, new Object[]{"Unable to change photo for external user"});
        this.userBinaryDataService.deleteUserPhoto(user);
        return new OperationCompletionRS("Profile photo has been deleted successfully");
    }

    @Override
    public OperationCompletionRS changePassword(ReportPortalUser loggedInUser, ChangePasswordRQ request) {
        User user = (User)this.userRepository.findByLogin(loggedInUser.getUsername()).orElseThrow(() -> new ReportPortalException(ErrorType.USER_NOT_FOUND, new Object[]{loggedInUser.getUsername()}));
        BusinessRule.expect((Object)user.getUserType(), (Predicate)Predicates.equalTo((Object)UserType.INTERNAL)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Impossible to change password for external users."});
        BusinessRule.expect((Object)this.passwordEncoder.matches((CharSequence)request.getOldPassword(), user.getPassword()), Predicate.isEqual(true)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Old password not match with stored."});
        user.setPassword(this.passwordEncoder.encode((CharSequence)request.getNewPassword()));
        this.userRepository.save((Object)user);
        return new OperationCompletionRS("Password has been changed successfully");
    }

    private void validatePhoto(MultipartFile file) {
        BusinessRule.expect((Object)(file.getSize() < 0x100000L ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BINARY_DATA_CANNOT_BE_SAVED, new Object[]{"Image size should be less than 1 mb"});
        MediaType mediaType = this.resolveMediaType(file);
        try (InputStream inputStream = file.getInputStream();){
            Dimension dimension = this.getImageDimension(mediaType, inputStream).orElseThrow(() -> new ReportPortalException(ErrorType.BINARY_DATA_CANNOT_BE_SAVED, new Object[]{"Unable to resolve image size"}));
            BusinessRule.expect((Object)(dimension.getHeight() <= 500.0 && dimension.getWidth() <= 300.0 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BINARY_DATA_CANNOT_BE_SAVED, new Object[]{"Image size should be 300x500px or less"});
        }
        catch (IOException e) {
            BusinessRule.fail().withError(ErrorType.BINARY_DATA_CANNOT_BE_SAVED, new Object[0]);
        }
    }

    private MediaType resolveMediaType(MultipartFile file) {
        return Optional.ofNullable(file.getContentType()).flatMap(string -> Optional.ofNullable(MediaType.parse((String)string)).filter(mediaType -> ImageFormat.fromValue((String)mediaType.getSubtype()).isPresent())).orElseGet(() -> {
            MediaType mediaType;
            block8: {
                TikaInputStream tikaInputStream = TikaInputStream.get((InputStream)file.getInputStream());
                try {
                    MediaType mediaType2 = this.autoDetectParser.getDetector().detect((InputStream)tikaInputStream, new Metadata());
                    BusinessRule.expect((Object)ImageFormat.fromValue((String)mediaType2.getSubtype()), Optional::isPresent).verify(ErrorType.BINARY_DATA_CANNOT_BE_SAVED, new Object[]{"Image format should be " + ImageFormat.getValues()});
                    mediaType = mediaType2;
                    if (tikaInputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (tikaInputStream != null) {
                            try {
                                tikaInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new ReportPortalException(ErrorType.BINARY_DATA_CANNOT_BE_SAVED, new Object[0]);
                    }
                }
                tikaInputStream.close();
            }
            return mediaType;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Dimension> getImageDimension(MediaType mediaType, InputStream inputStream) {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByMIMEType(String.valueOf(mediaType));
        while (iterator.hasNext()) {
            Optional<Dimension> optional;
            ImageReader reader;
            block11: {
                reader = iterator.next();
                ImageInputStream stream = ImageIO.createImageInputStream(inputStream);
                try {
                    reader.setInput(stream);
                    int width = reader.getWidth(reader.getMinIndex());
                    int height = reader.getHeight(reader.getMinIndex());
                    optional = Optional.of(new Dimension(width, height));
                    if (stream == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            reader.dispose();
                            continue;
                        }
                    }
                    catch (Throwable throwable3) {
                        reader.dispose();
                        throw throwable3;
                    }
                }
                stream.close();
            }
            reader.dispose();
            return optional;
        }
        return Optional.empty();
    }
}

