/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader;

import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.core.widget.content.LoadContentStrategy;
import com.epam.ta.reportportal.core.widget.content.loader.AbstractStatisticsContentLoader;
import com.epam.ta.reportportal.core.widget.util.WidgetFilterUtil;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.dao.WidgetContentRepository;
import com.epam.ta.reportportal.entity.widget.WidgetOptions;
import com.epam.ta.reportportal.entity.widget.content.ChartStatisticsContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class CasesTrendContentLoader
extends AbstractStatisticsContentLoader
implements LoadContentStrategy {
    @Autowired
    private WidgetContentRepository widgetContentRepository;

    @Override
    public Map<String, ?> loadContent(List<String> contentFields, Map<Filter, Sort> filterSortMapping, WidgetOptions widgetOptions, int limit) {
        Filter filter = WidgetFilterUtil.GROUP_FILTERS.apply(filterSortMapping.keySet());
        Sort sort = WidgetFilterUtil.GROUP_SORTS.apply(filterSortMapping.values());
        String contentField = contentFields.get(0);
        List content = this.widgetContentRepository.casesTrendStatistics(filter, contentField, sort, limit);
        return CollectionUtils.isEmpty((Collection)content) ? Collections.emptyMap() : this.calculateStatistics(widgetOptions, content, contentField, sort);
    }

    private Map<String, ?> calculateStatistics(WidgetOptions widgetOptions, List<ChartStatisticsContent> content, String contentField, Sort sort) {
        Optional<AbstractStatisticsContentLoader.Period> period;
        String timeLineOption = WidgetOptionUtil.getValueByKey("timeline", widgetOptions);
        if (StringUtils.isNotBlank((CharSequence)timeLineOption) && (period = AbstractStatisticsContentLoader.Period.findByName(timeLineOption)).isPresent()) {
            Map<String, ChartStatisticsContent> statistics = this.maxByDate(content, period.get(), contentField);
            this.calculateDelta(statistics, sort, contentField);
            return Collections.singletonMap("result", statistics);
        }
        return Collections.singletonMap("result", content);
    }

    private void calculateDelta(Map<String, ChartStatisticsContent> statistics, Sort sort, String contentField) {
        if (sort.get().anyMatch(Sort.Order::isAscending)) {
            ArrayList<String> keys = new ArrayList<String>(statistics.keySet());
            int previous = Integer.parseInt((String)statistics.get(keys.get(keys.size() - 1)).getValues().get(contentField));
            for (int i = keys.size() - 1; i >= 0; --i) {
                int current = Integer.parseInt((String)statistics.get(keys.get(i)).getValues().get(contentField));
                statistics.get(keys.get(i)).getValues().put("delta", String.valueOf(current - previous));
                previous = current;
            }
        } else {
            int previousValue = Integer.parseInt((String)new ArrayList<ChartStatisticsContent>(statistics.values()).get(0).getValues().get(contentField));
            for (ChartStatisticsContent content : statistics.values()) {
                Map values = content.getValues();
                int currentValue = Integer.parseInt((String)values.get(contentField));
                values.put("delta", String.valueOf(currentValue - previousValue));
                previousValue = currentValue;
            }
        }
    }
}

