/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.admin.ServerAdminHandler;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.settings.AnalyticsResource;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/settings"})
@PreAuthorize(value="hasRole('ADMINISTRATOR')")
public class SettingsController {
    private final ServerAdminHandler serverHandler;

    @Autowired
    public SettingsController(ServerAdminHandler serverHandler) {
        this.serverHandler = serverHandler;
    }

    @Transactional
    @RequestMapping(value={"/analytics"}, method={RequestMethod.PUT, RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Update analytics settings")
    public OperationCompletionRS saveAnalyticsSettings(@RequestBody @Validated AnalyticsResource request, @AuthenticationPrincipal ReportPortalUser user) {
        return this.serverHandler.saveAnalyticsSettings(request);
    }

    @Transactional(readOnly=true)
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get server settings")
    public Map<String, String> getServerSettings(@AuthenticationPrincipal ReportPortalUser user) {
        return this.serverHandler.getServerSettings();
    }
}

