/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.core.analyzer.auto.indexer.IndexerStatusCache;
import com.epam.ta.reportportal.entity.enums.ProjectAttributeEnum;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.entity.project.ProjectIssueType;
import com.epam.ta.reportportal.entity.project.ProjectUtils;
import com.epam.ta.reportportal.entity.project.email.SenderCase;
import com.epam.ta.reportportal.ws.converter.converters.IntegrationConverter;
import com.epam.ta.reportportal.ws.converter.converters.NotificationConfigConverter;
import com.epam.ta.reportportal.ws.converter.converters.PatternTemplateConverter;
import com.epam.ta.reportportal.ws.converter.converters.ProjectSettingsConverter;
import com.epam.ta.reportportal.ws.model.project.ProjectConfiguration;
import com.epam.ta.reportportal.ws.model.project.ProjectResource;
import com.epam.ta.reportportal.ws.model.project.email.ProjectNotificationConfigDTO;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class ProjectConverter {
    private static final String INDEXING_RUN = "analyzer.indexingRunning";
    @Autowired
    private IndexerStatusCache indexerStatusCache;
    public Function<Project, ProjectResource> TO_PROJECT_RESOURCE = project -> {
        if (project == null) {
            return null;
        }
        ProjectResource projectResource = new ProjectResource();
        projectResource.setProjectId(project.getId());
        projectResource.setProjectName(project.getName());
        projectResource.setEntryType(project.getProjectType().name());
        projectResource.setCreationDate(project.getCreationDate());
        projectResource.setAllocatedStorage(Long.valueOf(project.getAllocatedStorage()));
        projectResource.setUsers(project.getUsers().stream().map(user -> {
            ProjectResource.ProjectUser projectUser = new ProjectResource.ProjectUser();
            projectUser.setLogin(user.getUser().getLogin());
            projectUser.setProjectRole(user.getProjectRole().toString());
            return projectUser;
        }).collect(Collectors.toList()));
        Map subTypes = project.getProjectIssueTypes().stream().map(ProjectIssueType::getIssueType).collect(Collectors.groupingBy(it -> it.getIssueGroup().getTestItemIssueGroup().getValue(), Collectors.mapping(ProjectSettingsConverter.TO_SUBTYPE_RESOURCE, Collectors.toList())));
        ProjectConfiguration projectConfiguration = new ProjectConfiguration();
        Map attributes = ProjectUtils.getConfigParameters((Set)project.getProjectAttributes());
        attributes.put(INDEXING_RUN, String.valueOf(Optional.ofNullable((Boolean)this.indexerStatusCache.getIndexingStatus().getIfPresent((Object)project.getId())).orElse(false)));
        projectConfiguration.setProjectAttributes(attributes);
        projectConfiguration.setPatterns(project.getPatternTemplates().stream().map(PatternTemplateConverter.TO_RESOURCE).collect(Collectors.toList()));
        projectResource.setIntegrations(project.getIntegrations().stream().map(IntegrationConverter.TO_INTEGRATION_RESOURCE).collect(Collectors.toList()));
        ProjectNotificationConfigDTO notificationConfig = new ProjectNotificationConfigDTO();
        notificationConfig.setEnabled(BooleanUtils.toBoolean((String)((String)attributes.get(ProjectAttributeEnum.NOTIFICATIONS_ENABLED.getAttribute()))));
        Optional.ofNullable(project.getSenderCases()).ifPresent(senderCases -> notificationConfig.setSenderCases(NotificationConfigConverter.TO_RESOURCE.apply((Set<SenderCase>)senderCases)));
        projectConfiguration.setProjectConfig(notificationConfig);
        projectConfiguration.setSubTypes(subTypes);
        projectResource.setConfiguration(projectConfiguration);
        projectResource.setOrganization(project.getOrganization());
        return projectResource;
    };
}

