/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.entity.ShareableEntity;
import com.epam.ta.reportportal.entity.filter.FilterSort;
import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.ws.converter.converters.SharedEntityConverter;
import com.epam.ta.reportportal.ws.model.SharedEntity;
import com.epam.ta.reportportal.ws.model.activity.UserFilterActivityResource;
import com.epam.ta.reportportal.ws.model.filter.Order;
import com.epam.ta.reportportal.ws.model.filter.UserFilterCondition;
import com.epam.ta.reportportal.ws.model.filter.UserFilterResource;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class UserFilterConverter {
    public static final Function<UserFilter, SharedEntity> TO_SHARED_ENTITY = filter -> {
        SharedEntity sharedEntity = SharedEntityConverter.TO_SHARED_ENTITY.apply((ShareableEntity)filter);
        sharedEntity.setName(filter.getName());
        sharedEntity.setDescription(filter.getDescription());
        return sharedEntity;
    };
    public static final Function<Set<UserFilter>, List<UserFilterResource>> FILTER_SET_TO_FILTER_RESOURCE = filters -> filters.stream().map(UserFilterConverter::buildFilterResource).collect(Collectors.toList());
    public static final Function<UserFilter, UserFilterResource> TO_FILTER_RESOURCE = UserFilterConverter::buildFilterResource;
    public static final Function<UserFilter, UserFilterActivityResource> TO_ACTIVITY_RESOURCE = filter -> {
        UserFilterActivityResource resource = new UserFilterActivityResource();
        resource.setId(filter.getId());
        resource.setName(filter.getName());
        resource.setDescription(filter.getDescription());
        resource.setProjectId(filter.getProject().getId());
        resource.setShared(filter.isShared());
        return resource;
    };
    private static final Function<FilterCondition, UserFilterCondition> TO_FILTER_CONDITION = filterCondition -> {
        UserFilterCondition condition = new UserFilterCondition();
        Optional.ofNullable(filterCondition.getCondition()).ifPresent(c -> {
            if (filterCondition.isNegative()) {
                condition.setCondition("!".concat(c.getMarker()));
            } else {
                condition.setCondition(c.getMarker());
            }
        });
        condition.setFilteringField(filterCondition.getSearchCriteria());
        condition.setValue(filterCondition.getValue());
        return condition;
    };
    private static final Function<FilterSort, Order> TO_FILTER_ORDER = filterSort -> {
        Order order = new Order();
        order.setSortingColumnName(filterSort.getField());
        order.setIsAsc(filterSort.getDirection().isAscending());
        return order;
    };

    private UserFilterConverter() {
    }

    private static UserFilterResource buildFilterResource(UserFilter filter) {
        UserFilterResource userFilterResource = new UserFilterResource();
        userFilterResource.setFilterId(filter.getId());
        userFilterResource.setName(filter.getName());
        userFilterResource.setDescription(filter.getDescription());
        userFilterResource.setShare(filter.isShared());
        userFilterResource.setOwner(filter.getOwner());
        Optional.ofNullable(filter.getTargetClass()).ifPresent(tc -> userFilterResource.setObjectType(tc.getClassObject().getSimpleName()));
        Optional.ofNullable(filter.getFilterCondition()).ifPresent(fcs -> userFilterResource.setConditions(fcs.stream().map(TO_FILTER_CONDITION).collect(Collectors.toSet())));
        Optional.ofNullable(filter.getFilterSorts()).ifPresent(fs -> userFilterResource.setOrders(fs.stream().map(TO_FILTER_ORDER).collect(Collectors.toList())));
        return userFilterResource;
    }
}

