/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.rabbit;

import com.epam.ta.reportportal.binary.DataStoreService;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.events.attachment.DeleteAttachmentEvent;
import com.epam.ta.reportportal.dao.AttachmentRepository;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
public class AttachmentConsumer {
    public static final Logger LOGGER = LoggerFactory.getLogger(AttachmentConsumer.class);
    private final DataStoreService dataStoreService;
    private final AttachmentRepository attachmentRepository;

    @Autowired
    public AttachmentConsumer(@Qualifier(value="attachmentDataStoreService") DataStoreService dataStoreService, AttachmentRepository attachmentRepository) {
        this.dataStoreService = dataStoreService;
        this.attachmentRepository = attachmentRepository;
    }

    @RabbitListener(queues={"#{ @deleteAttachmentQueue.name }"})
    public void onEvent(@Payload DeleteAttachmentEvent event) {
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)event.getIds().size());
        event.getIds().forEach(id -> this.attachmentRepository.findById(id).ifPresent(a -> {
            try {
                Optional.ofNullable(a.getFileId()).ifPresent(arg_0 -> ((DataStoreService)this.dataStoreService).delete(arg_0));
                Optional.ofNullable(a.getThumbnailId()).ifPresent(arg_0 -> ((DataStoreService)this.dataStoreService).delete(arg_0));
                ids.add(id);
            }
            catch (Exception e) {
                LOGGER.error((String)Suppliers.formattedSupplier((String)"Error during removing attachment with id = {}", (Object[])new Object[]{id}).get());
            }
        }));
        Optional.ofNullable(event.getPaths()).ifPresent(paths -> paths.forEach(arg_0 -> ((DataStoreService)this.dataStoreService).delete(arg_0)));
        this.attachmentRepository.deleteAllByIds((Collection)ids);
    }
}

