/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.rabbit;

import com.epam.ta.reportportal.core.configs.Conditions;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.ListenerContainerConsumerFailedEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={Conditions.NotTestCondition.class})
public class ConsumerEventListener
implements ApplicationListener<ListenerContainerConsumerFailedEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerEventListener.class);
    @Autowired
    @Qualifier(value="queues")
    private List<Queue> queues;
    @Autowired
    private ConnectionFactory connectionFactory;

    public void onApplicationEvent(ListenerContainerConsumerFailedEvent event) {
        Object source = event.getSource();
        if (source instanceof AbstractMessageListenerContainer) {
            AbstractMessageListenerContainer listenerContainer = (AbstractMessageListenerContainer)source;
            Throwable throwable = event.getThrowable();
            if (throwable.getCause() instanceof IOException && throwable.getCause().getCause() instanceof ShutdownSignalException && throwable.getCause().getCause().getMessage().contains("in exclusive use")) {
                for (Queue q : this.queues) {
                    if (this.getQueueConsumerCount(q) != 0) continue;
                    listenerContainer.setQueues(new Queue[]{q});
                    LOGGER.info("Restarting consumer with a queue {}", (Object)q.getName());
                }
            }
        }
    }

    private int getQueueConsumerCount(Queue queue) {
        int n;
        block8: {
            Channel channel = this.connectionFactory.createConnection().createChannel(false);
            try {
                n = channel.queueDeclarePassive(queue.getName()).getConsumerCount();
                if (channel == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | TimeoutException e) {
                    throw new ReportPortalException(e.getMessage());
                }
            }
            channel.close();
        }
        return n;
    }
}

