/*
 * Decompiled with CFR 0.152.
 */
package com.epion_t3.aws.core.holder;

import com.epion_t3.aws.core.configuration.AwsCredentialsProviderConfiguration;
import com.epion_t3.aws.core.util.AwsCredentialsProviderUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public final class AwsCredentialsProviderHolder {
    private static final AwsCredentialsProviderHolder instance = new AwsCredentialsProviderHolder();
    private static final Map<String, AwsCredentialsProvider> providerMap = new ConcurrentHashMap<String, AwsCredentialsProvider>();

    public static AwsCredentialsProviderHolder getInstance() {
        return instance;
    }

    public AwsCredentialsProvider getCredentialsProvider(AwsCredentialsProviderConfiguration configuration) {
        if (providerMap.containsKey(configuration.getId())) {
            return providerMap.get(configuration.getId());
        }
        AwsCredentialsProvider provider = AwsCredentialsProviderUtils.getInstance().resolveCredentialsProvider(configuration);
        providerMap.put(configuration.getId(), provider);
        return provider;
    }
}

