/*
 * Decompiled with CFR 0.152.
 */
package com.epion_t3.aws.core.holder;

import com.epion_t3.aws.core.configuration.AwsSdkHttpClientConfiguration;
import com.epion_t3.aws.core.util.AwsSdkHttpClientUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.awssdk.http.SdkHttpClient;

public final class AwsSdkHttpClientHolder {
    private static final AwsSdkHttpClientHolder instance = new AwsSdkHttpClientHolder();
    private static final Map<String, SdkHttpClient> clientMap = new ConcurrentHashMap<String, SdkHttpClient>();

    public static AwsSdkHttpClientHolder getInstance() {
        return instance;
    }

    public SdkHttpClient getSdkHttpClient(AwsSdkHttpClientConfiguration configuration) {
        if (clientMap.containsKey(configuration.getId())) {
            return clientMap.get(configuration.getId());
        }
        SdkHttpClient provider = AwsSdkHttpClientUtils.getInstance().resolveSdkHttpClient(configuration);
        clientMap.put(configuration.getId(), provider);
        return provider;
    }
}

