/*
 * Decompiled with CFR 0.152.
 */
package com.epion_t3.aws.core.util;

import com.epion_t3.aws.core.configuration.AwsSdkHttpClientConfiguration;
import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.apache.commons.lang3.StringUtils;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;

public final class AwsSdkHttpClientUtils {
    private static final AwsSdkHttpClientUtils instance = new AwsSdkHttpClientUtils();

    public static AwsSdkHttpClientUtils getInstance() {
        return instance;
    }

    public SdkHttpClient resolveSdkHttpClient(AwsSdkHttpClientConfiguration configuration) {
        ApacheHttpClient.Builder builder = ApacheHttpClient.builder();
        if (configuration.getConnectTimeout() != null) {
            builder.connectionTimeout(Duration.of(configuration.getConnectTimeout(), ChronoUnit.MILLIS));
        }
        if (configuration.getSocketTimeout() != null) {
            builder.socketTimeout(Duration.of(configuration.getSocketTimeout(), ChronoUnit.MILLIS));
        }
        if (StringUtils.isNotEmpty((CharSequence)configuration.getProxyEndpoint())) {
            if (StringUtils.isNotEmpty((CharSequence)configuration.getUsername()) && StringUtils.isNotEmpty((CharSequence)configuration.getPassword())) {
                builder.proxyConfiguration((ProxyConfiguration)ProxyConfiguration.builder().endpoint(URI.create(configuration.getProxyEndpoint())).username(configuration.getUsername()).password(configuration.getPassword()).build());
            } else {
                builder.proxyConfiguration((ProxyConfiguration)ProxyConfiguration.builder().endpoint(URI.create(configuration.getProxyEndpoint())).build());
            }
        }
        return builder.build();
    }
}

