/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca46.process;

import java.sql.Timestamp;
import java.util.Optional;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.acct.SessionPoster;
import org.compiere.model.MAcctProcessor;
import org.compiere.model.MAcctProcessorLog;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaProvider;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.spin.eca46.process.AcctProcessorAbstract;

public class AcctProcessor
extends AcctProcessorAbstract {
    private MAcctProcessor acctProcessor = null;
    private MAcctSchemaProvider provider = new MAcctSchemaProvider();
    private SessionPoster sessionPoster = new SessionPoster();
    private StringBuilder summary = new StringBuilder("Just initialized ");
    private long startWork;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getAcctProcessorId() <= 0) {
            throw new AdempiereException("@C_AcctProcessor_ID@ @NotFound@");
        }
        this.acctProcessor = new MAcctProcessor(this.getCtx(), this.getAcctProcessorId(), this.get_TrxName());
    }

    protected String doIt() throws Exception {
        this.startWork = System.currentTimeMillis();
        String results = this.getSessionPoster().withAccountingSchemas(this.getAcctSchemas()).post();
        this.updateLog(results);
        return TimeUtil.formatElapsed((Timestamp)new Timestamp(this.startWork));
    }

    MAcctSchemaProvider getAcctSchemaProvider() {
        return this.provider;
    }

    private MAcctSchema[] getAcctSchemas() {
        return this.getAcctSchemaProvider().getAcctSchemas(this.getCtx(), this.getAD_Client_ID(), this.getC_AcctSchema_ID(), null);
    }

    int getC_AcctSchema_ID() {
        return this.acctProcessor.getC_AcctSchema_ID();
    }

    public String getServerInfo() {
        return "Last=" + Optional.ofNullable(this.summary.toString()).orElse("");
    }

    SessionPoster getSessionPoster() {
        return this.sessionPoster;
    }

    void updateLog(String results) {
        this.summary = new StringBuilder(results);
        int no = this.acctProcessor.deleteLog();
        this.summary.append("Logs deleted=").append(no);
        if (this.acctProcessor.get_TrxName() == null) {
            Trx.run(this::addAcctProcessorLog);
        } else {
            this.addAcctProcessorLog(this.acctProcessor.get_TrxName());
        }
    }

    private void addAcctProcessorLog(String trxName) {
        MAcctProcessorLog acctProcessorLog = new MAcctProcessorLog(this.acctProcessor, this.summary.toString(), trxName);
        acctProcessorLog.setReference(TimeUtil.formatElapsed((Timestamp)new Timestamp(this.startWork)));
        acctProcessorLog.saveEx();
    }
}

