/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca46.process;

import java.io.File;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.impexp.ArrayExcelExporter;
import org.compiere.model.MAlert;
import org.compiere.model.MAlertProcessor;
import org.compiere.model.MAlertProcessorLog;
import org.compiere.model.MAlertRule;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.ValueNamePair;
import org.spin.eca46.process.AlertProcessorAbstract;
import org.spin.queue.notification.DefaultNotifier;
import org.spin.queue.util.QueueLoader;

public class AlertProcessor
extends AlertProcessorAbstract {
    private long startWork;
    private MAlertProcessor alertProcessor = null;
    private StringBuffer m_summary = new StringBuffer();
    private StringBuffer m_errors = new StringBuffer();

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getAlertProcessorId() <= 0) {
            throw new AdempiereException("@AD_AlertProcessor_ID@ @NotFound@");
        }
        this.alertProcessor = new MAlertProcessor(this.getCtx(), this.getAlertProcessorId(), this.get_TrxName());
    }

    protected String doIt() throws Exception {
        this.startWork = System.currentTimeMillis();
        this.m_summary = new StringBuffer();
        this.m_errors = new StringBuffer();
        int count = 0;
        int countError = 0;
        MAlert[] alerts = this.alertProcessor.getAlerts(false);
        for (int i = 0; i < alerts.length; ++i) {
            if (!this.processAlert(alerts[i])) {
                ++countError;
            }
            ++count;
        }
        String summary = "Total=" + count;
        if (countError > 0) {
            summary = summary + ", Not processed=" + countError;
        }
        summary = summary + " - ";
        this.m_summary.insert(0, summary);
        int no = this.alertProcessor.deleteLog();
        this.m_summary.append("Logs deleted=").append(no);
        if (this.alertProcessor.get_TrxName() == null) {
            Trx.run(this::addAlertProcessorLog);
        } else {
            this.addAlertProcessorLog(this.alertProcessor.get_TrxName());
        }
        return TimeUtil.formatElapsed((Timestamp)new Timestamp(this.startWork));
    }

    private void addAlertProcessorLog(String trxName) {
        MAlertProcessorLog alertProcessorLog = new MAlertProcessorLog(this.alertProcessor, this.m_summary.toString(), trxName);
        alertProcessorLog.setReference(TimeUtil.formatElapsed((Timestamp)new Timestamp(this.startWork)));
        alertProcessorLog.setTextMsg(this.m_errors.toString());
        alertProcessorLog.saveEx();
    }

    private boolean processAlert(MAlert alert) {
        if (!alert.isValid()) {
            return false;
        }
        this.log.info("" + alert);
        StringBuffer message = new StringBuffer(alert.getAlertMessage()).append(Env.NL);
        boolean valid = true;
        boolean processed = false;
        ArrayList<File> attachments = new ArrayList<File>();
        MAlertRule[] rules = alert.getRules(false);
        for (int i = 0; i < rules.length; ++i) {
            int no;
            String sql;
            MAlertRule rule;
            String trxName;
            block8: {
                int no2;
                if (i > 0) {
                    message.append(Env.NL);
                }
                trxName = null;
                rule = rules[i];
                if (!rule.isValid()) continue;
                this.log.fine("" + rule);
                sql = rule.getPreProcessing();
                if (sql != null && sql.length() > 0 && (no2 = DB.executeUpdate((String)sql, (boolean)false, trxName)) == -1) {
                    ValueNamePair error = CLogger.retrieveError();
                    rule.setErrorMsg("Pre=" + error.getName());
                    this.m_errors.append("Pre=" + error.getName());
                    rule.setIsValid(false);
                    rule.saveEx();
                    valid = false;
                    break;
                }
                sql = rule.getSql(true);
                try {
                    String text = null;
                    text = MSysConfig.getBooleanValue((String)"ALERT_SEND_ATTACHMENT_AS_XLS", (boolean)true, (int)Env.getAD_Client_ID((Properties)this.getCtx())) ? this.getExcelReport(rule, sql, trxName, attachments) : this.getPlainTextReport(rule, sql, trxName, attachments);
                    if (text == null || text.length() <= 0) break block8;
                    message.append(text);
                    processed = true;
                }
                catch (Exception e) {
                    rule.setErrorMsg("Select=" + e.getLocalizedMessage());
                    this.m_errors.append("Select=" + e.getLocalizedMessage());
                    rule.setIsValid(false);
                    rule.saveEx();
                    valid = false;
                    break;
                }
            }
            sql = rule.getPostProcessing();
            if (sql == null || sql.length() <= 0 || (no = DB.executeUpdate((String)sql, (boolean)false, trxName)) != -1) continue;
            ValueNamePair error = CLogger.retrieveError();
            rule.setErrorMsg("Post=" + error.getName());
            this.m_errors.append("Post=" + error.getName());
            rule.setIsValid(false);
            rule.saveEx();
            valid = false;
            break;
        }
        if (!valid) {
            alert.setIsValid(false);
            alert.saveEx();
            return false;
        }
        if (!processed) {
            this.m_summary.append(alert.getName()).append("=No Result - ");
            return true;
        }
        SimpleDateFormat df = DisplayType.getDateFormat((int)16);
        message.append("\n\n");
        message.append(Msg.translate((Properties)this.getCtx(), (String)"Date")).append(" : ").append(df.format(new Timestamp(System.currentTimeMillis())));
        Collection users = alert.getRecipientUsers();
        int countMail = this.notifyUsers(users, alert.getAlertSubject(), message.toString(), attachments);
        this.m_summary.append(alert.getName()).append(" (EMails+Notes=").append(countMail).append(") - ");
        return valid;
    }

    private int notifyUsers(Collection<Integer> users, String subject, String message, Collection<File> attachments) {
        AtomicInteger countMail = new AtomicInteger(0);
        users.forEach(userId -> Trx.run(transactionName -> {
            DefaultNotifier notifier = (DefaultNotifier)QueueLoader.getInstance().getQueueManager("NTF").withContext(this.getCtx()).withTransactionName(transactionName);
            notifier.clearMessage().withApplicationType("UDP").addRecipient(userId.intValue()).withText(message).withDescription(subject);
            attachments.forEach(attachment -> notifier.addAttachment(attachment));
            notifier.addToQueue();
            countMail.incrementAndGet();
        }));
        return countMail.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ArrayList<Object>> getData(String sql, String trxName) throws Exception {
        ArrayList<ArrayList<Object>> data = new ArrayList<ArrayList<Object>>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        Exception error = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            rs = pstmt.executeQuery();
            ResultSetMetaData meta = rs.getMetaData();
            boolean isFirstRow = true;
            while (rs.next()) {
                ArrayList<String> header = isFirstRow ? new ArrayList<String>() : null;
                ArrayList<Object> row = new ArrayList<Object>();
                for (int col = 1; col <= meta.getColumnCount(); ++col) {
                    if (isFirstRow) {
                        String columnName = meta.getColumnLabel(col);
                        header.add(columnName);
                    }
                    Object o = rs.getObject(col);
                    row.add(o);
                }
                if (isFirstRow) {
                    data.add(header);
                }
                data.add(row);
                isFirstRow = false;
            }
        }
        catch (Throwable e) {
            try {
                this.log.log(Level.SEVERE, sql, e);
                error = e instanceof Exception ? (Exception)e : new Exception(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        if (error != null) {
            throw new Exception("(" + sql + ") " + Env.NL + error.getLocalizedMessage());
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPlainTextReport(MAlertRule rule, String sql, String trxName, Collection<File> attachments) throws Exception {
        Exception error;
        ResultSet rs;
        CPreparedStatement pstmt;
        StringBuffer result;
        block7: {
            result = new StringBuffer();
            pstmt = null;
            rs = null;
            error = null;
            try {
                pstmt = DB.prepareStatement((String)sql, (String)trxName);
                rs = pstmt.executeQuery();
                ResultSetMetaData meta = rs.getMetaData();
                while (rs.next()) {
                    result.append("------------------").append(Env.NL);
                    for (int col = 1; col <= meta.getColumnCount(); ++col) {
                        result.append(meta.getColumnLabel(col)).append(" = ");
                        result.append(rs.getString(col));
                        result.append(Env.NL);
                    }
                }
                if (result.length() != 0) break block7;
                this.log.fine("No rows selected");
            }
            catch (Throwable e) {
                try {
                    this.log.log(Level.SEVERE, sql, e);
                    error = e instanceof Exception ? (Exception)e : new Exception(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        if (error != null) {
            throw new Exception("(" + sql + ") " + Env.NL + error.getLocalizedMessage());
        }
        return result.toString();
    }

    private String getExcelReport(MAlertRule rule, String sql, String trxName, Collection<File> attachments) throws Exception {
        ArrayList<ArrayList<Object>> data = this.getData(sql, trxName);
        if (data.size() <= 1) {
            return null;
        }
        File file = rule.createReportFile("xls");
        ArrayExcelExporter exporter = new ArrayExcelExporter(this.getCtx(), data, Boolean.valueOf(false));
        exporter.export(file, null, false);
        attachments.add(file);
        String msg = rule.getName() + " (@SeeAttachment@ " + file.getName() + ")" + Env.NL;
        return Msg.parseTranslation((Properties)Env.getCtx(), (String)msg);
    }

    public String getServerInfo() {
        return "Last=" + this.m_summary.toString();
    }
}

