/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca46.process;

import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAcctProcessor;
import org.compiere.model.MAlertProcessor;
import org.compiere.model.MRequestProcessor;
import org.compiere.model.MScheduler;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.compiere.wf.MWorkflowProcessor;
import org.eevolution.model.MProjectProcessor;
import org.spin.eca46.process.ExportInternalProcessorsAbstract;
import org.spin.eca46.util.support.Accounting;
import org.spin.eca46.util.support.Alert;
import org.spin.eca46.util.support.IExternalProcessor;
import org.spin.eca46.util.support.IProcessorEntity;
import org.spin.eca46.util.support.Project;
import org.spin.eca46.util.support.Request;
import org.spin.eca46.util.support.Schedule;
import org.spin.eca46.util.support.Workflow;
import org.spin.model.MADAppRegistration;
import org.spin.util.IThirdPartyAccessGenerator;
import org.spin.util.ITokenGenerator;
import org.spin.util.TokenGeneratorHandler;
import org.spin.util.support.AppSupportHandler;
import org.spin.util.support.IAppSupport;

public class ExportInternalProcessors
extends ExportInternalProcessorsAbstract {
    private AtomicInteger counter = new AtomicInteger();

    protected String doIt() throws Exception {
        ArrayList processorsList = new ArrayList();
        new Query(this.getCtx(), "C_AcctProcessor", null, this.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).getIDsAsList().forEach(processorId -> processorsList.add(Accounting.newInstance().withAccountingProcessor(new MAcctProcessor(this.getCtx(), processorId.intValue(), this.get_TrxName()))));
        new Query(this.getCtx(), "AD_AlertProcessor", null, this.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).getIDsAsList().forEach(processorId -> processorsList.add(Alert.newInstance().withAlertProcessor(new MAlertProcessor(this.getCtx(), processorId.intValue(), this.get_TrxName()))));
        new Query(this.getCtx(), "C_ProjectProcessor", null, this.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).getIDsAsList().forEach(processorId -> processorsList.add(Project.newInstance().withProjectProcessor(new MProjectProcessor(this.getCtx(), processorId.intValue(), this.get_TrxName()))));
        new Query(this.getCtx(), "R_RequestProcessor", null, this.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).getIDsAsList().forEach(processorId -> processorsList.add(Request.newInstance().withRequestProcessor(new MRequestProcessor(this.getCtx(), processorId.intValue(), this.get_TrxName()))));
        new Query(this.getCtx(), "AD_Scheduler", null, this.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).getIDsAsList().forEach(processorId -> processorsList.add(Schedule.newInstance().withSchedulerProcessor(new MScheduler(this.getCtx(), processorId.intValue(), this.get_TrxName()))));
        new Query(this.getCtx(), "AD_WorkflowProcessor", null, this.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).getIDsAsList().forEach(processorId -> processorsList.add(Workflow.newInstance().withWorkflowProcessor(new MWorkflowProcessor(this.getCtx(), processorId.intValue(), this.get_TrxName()))));
        MADAppRegistration registeredApplication = MADAppRegistration.getById((Properties)Env.getCtx(), (int)this.getExternalProcessorId(), (String)this.get_TrxName());
        IAppSupport supportedApplication = AppSupportHandler.getInstance().getAppSupport(registeredApplication);
        if (supportedApplication != null && IExternalProcessor.class.isAssignableFrom(supportedApplication.getClass())) {
            IExternalProcessor dKronProcessor = (IExternalProcessor)supportedApplication;
            dKronProcessor.setHost(this.getHost());
            dKronProcessor.setTokenAccess(this.getToken());
            processorsList.forEach(processor -> {
                String result = dKronProcessor.exportProcessor((IProcessorEntity)processor);
                this.counter.incrementAndGet();
                if (!Util.isEmpty((String)result)) {
                    this.addLog(result);
                }
            });
        }
        return "@Created@: " + this.counter.get();
    }

    private String getToken() {
        try {
            boolean match = new Query(this.getCtx(), "AD_Role", "EXISTS(SELECT 1 FROM AD_User_Roles ur WHERE ur.AD_Role_ID = AD_Role.AD_Role_ID AND ur.AD_User_ID = ?)", this.get_TrxName()).setParameters(new Object[]{this.getUserId()}).match();
            if (!match) {
                throw new AdempiereException("@AD_User_ID@ / @AD_Role_ID@ @Mismatched@");
            }
            ITokenGenerator generator = TokenGeneratorHandler.getInstance().getTokenGenerator("TPA");
            if (generator == null) {
                throw new AdempiereException("@AD_TokenDefinition_ID@ @NotFound@");
            }
            if (!IThirdPartyAccessGenerator.class.isAssignableFrom(generator.getClass())) {
                throw new AdempiereException("@AD_TokenDefinition_ID@ @Invalid@");
            }
            IThirdPartyAccessGenerator thirdPartyAccessGenerator = (IThirdPartyAccessGenerator)generator;
            return thirdPartyAccessGenerator.generateToken(this.getUserId(), this.getRoleId());
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }
}

