/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca46.process;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MColumn;
import org.compiere.model.MMailText;
import org.compiere.model.MNote;
import org.compiere.model.MProject;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectProcessorChange;
import org.compiere.model.MProjectProcessorQueued;
import org.compiere.model.MProjectTask;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.project.services.ProjectProcessorService;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.eevolution.model.MProjectProcessor;
import org.eevolution.model.MProjectProcessorLog;
import org.eevolution.model.MProjectStatus;
import org.spin.eca46.process.ProjectProcessorAbstract;
import org.spin.eca46.process.ScheduleChange;
import org.spin.queue.notification.DefaultNotifier;
import org.spin.queue.util.QueueLoader;

public class ProjectProcessor
extends ProjectProcessorAbstract {
    private long startWork;
    private MProjectProcessor projectProcessor = null;
    private StringBuffer summary = new StringBuffer();
    private PO entity = null;
    private ArrayList<String> columns = new ArrayList();
    private ArrayList<String> values = new ArrayList();
    private MProject project = null;
    private MProjectPhase projectPhase = null;
    private MProjectTask projectTask = null;
    private String prefixSubject = "";
    private String prefixTextMail = "";
    private String textNotice = "";
    private MMailText mailText = null;
    private String extraMsg = "";
    private boolean isScheduled = false;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getProjectProcessorId() <= 0) {
            throw new AdempiereException("@C_ProjectProcessor_ID@ @NotFound@");
        }
        this.projectProcessor = new MProjectProcessor(this.getCtx(), this.getProjectProcessorId(), this.get_TrxName());
    }

    protected String doIt() throws Exception {
        this.startWork = System.currentTimeMillis();
        this.summary = new StringBuffer();
        this.mailText = new MMailText(Env.getCtx(), this.projectProcessor.getR_MailText_ID(), null);
        this.clearGlobals();
        this.processQueued();
        this.processProjects();
        this.processQueued();
        return TimeUtil.formatElapsed((Timestamp)new Timestamp(this.startWork));
    }

    private void processProjects() {
        this.processStartDateAlert();
        this.processStatus();
        this.processDueAlert();
        this.processOverDueAlert();
    }

    private void processQueued() {
        String whereClause = " EXISTS (SELECT 1 FROM C_ProjectProcessorQueued q WHERE q.SendEmail='N' AND q.C_ProjectProcessorLog_ID = C_ProjectProcessorLog.C_ProjectProcessorLog_ID )";
        MProjectProcessorLog[] pLogs = this.projectProcessor.getProcessorLogs(whereClause);
        boolean loadMsj = false;
        for (MProjectProcessorLog mProjectProcessorLog : pLogs) {
            MProjectProcessorQueued[] queued;
            loadMsj = this.loadMsgToSend(mProjectProcessorLog);
            for (MProjectProcessorQueued mProjectProcessorQueued : queued = mProjectProcessorLog.getQueued("SendEmail='N'")) {
                if (loadMsj) {
                    String NotificationType;
                    String string = NotificationType = Util.isEmpty((String)mProjectProcessorQueued.getNotificationType()) ? "X" : mProjectProcessorQueued.getNotificationType();
                    if (NotificationType.equals("E")) {
                        this.sendEmail(mProjectProcessorQueued);
                    } else if (NotificationType.equals("B")) {
                        this.sendEmail(mProjectProcessorQueued);
                        this.createNotice(mProjectProcessorQueued);
                    } else if (NotificationType.equals("N")) {
                        this.createNotice(mProjectProcessorQueued);
                    }
                }
                mProjectProcessorQueued.setSendEMail(true);
                mProjectProcessorQueued.save();
            }
            this.clearGlobals();
        }
    }

    private boolean sendEmail(MProjectProcessorQueued queued) {
        MUser recipient = (MUser)queued.getAD_User();
        this.mailText.setUser(recipient);
        if (this.entity != null) {
            this.mailText.setPO(this.entity);
        }
        Trx.run(transactionName -> {
            String subject = (String)(!Util.isEmpty((String)this.mailText.getMailHeader()) ? this.mailText.getMailHeader() + " " : this.mailText.getMailHeader()) + this.prefixSubject;
            String message = "";
            if (this.mailText.getR_MailText_ID() != 0) {
                message = this.mailText.getMailText(true);
            }
            DefaultNotifier notifier = (DefaultNotifier)QueueLoader.getInstance().getQueueManager("NTF").withContext(this.getCtx()).withTransactionName(transactionName);
            notifier.clearMessage().withApplicationType("UDP").withText(this.prefixTextMail + (message == null ? "" : message) + "\n").withDescription(subject);
            if (this.projectProcessor.getSupervisor_ID() != 0) {
                notifier.withUserId(this.projectProcessor.getSupervisor_ID());
            }
            notifier.addRecipient(queued.getAD_User_ID());
            if (this.entity != null) {
                notifier.withEntity(this.entity);
            }
            notifier.addToQueue();
        });
        return true;
    }

    private boolean createNotice(MProjectProcessorQueued queued) {
        MUser to = (MUser)queued.getAD_User();
        if (to.getAD_User_ID() != 0) {
            MNote note = new MNote(this.getCtx(), "Error", to.getAD_User_ID(), this.entity.get_TrxName());
            note.setRecord(this.entity.get_Table_ID(), this.entity.get_ID());
            note.setReference(this.prefixSubject);
            note.setTextMsg(this.textNotice);
            if (!note.save()) {
                return false;
            }
        }
        return true;
    }

    private void processStatus() {
        String whereClause = "";
        Timestamp currentDate = new Timestamp(TimeUtil.getToday().getTimeInMillis());
        whereClause = "EXISTS (SELECT 1 FROM C_ProjectStatus ps WHERE ps.C_ProjectStatus_ID = C_Project.C_ProjectStatus_ID AND ps.TimeoutDays > 0 AND ps.Next_Status_ID > 0 AND C_Project.DateLastAction + ps.TimeoutDays < ?) ";
        new ScheduleChange(this.getCtx(), "C_Project", whereClause, this.projectProcessor.get_TrxName()).setAlertMessageColumn("@C_ProjectStatus_ID@ @HasBeenChanged@").IsNextProjectStatus().setParameters(currentDate).processScheduleChanges();
        whereClause = "EXISTS (SELECT 1 FROM C_ProjectStatus ps WHERE ps.C_ProjectStatus_ID = C_ProjectPhase.C_ProjectStatus_ID AND ps.TimeoutDays > 0 AND ps.Next_Status_ID > 0 AND C_ProjectPhase.DateLastAction + ps.TimeoutDays < ?) ";
        new ScheduleChange(this.getCtx(), "C_ProjectPhase", whereClause, this.projectProcessor.get_TrxName()).setAlertMessageColumn("@C_ProjectStatus_ID@ @HasBeenChanged@").IsNextProjectStatus().setParameters(currentDate).processScheduleChanges();
        whereClause = "EXISTS (SELECT 1 FROM C_ProjectStatus ps WHERE ps.C_ProjectStatus_ID = C_ProjectTask.C_ProjectStatus_ID AND ps.TimeoutDays > 0 AND ps.Next_Status_ID > 0 AND C_ProjectTask.DateLastAction + ps.TimeoutDays < ?) ";
        new ScheduleChange(this.getCtx(), "C_ProjectTask", whereClause, this.projectProcessor.get_TrxName()).setAlertMessageColumn("@C_ProjectStatus_ID@ @HasBeenChanged@").IsNextProjectStatus().setParameters(currentDate).processScheduleChanges();
    }

    private void processStartDateAlert() {
        Object whereClauseGeneral = "";
        Object whereClause = "";
        this.isScheduled = true;
        ArrayList<Object> params = new ArrayList<Object>();
        Timestamp currentDate = new Timestamp(TimeUtil.getToday().getTimeInMillis());
        int daysBeforeStart = this.projectProcessor.get_ValueAsInt("DaysBeforeStart");
        whereClauseGeneral = "(DateStartSchedule IS NOT NULL AND DateStartSchedule - ? <= ? AND DateStartSchedule >= ?) AND (DueType IS NULL OR DueType = ?)";
        params.add(daysBeforeStart);
        params.add(currentDate);
        params.add(currentDate);
        params.add("7");
        whereClauseGeneral = (String)whereClauseGeneral + " AND (DateLastAlert IS NULL OR DateLastAlert!=?)";
        params.add(currentDate);
        if (this.projectProcessor.getC_ProjectType_ID() != 0) {
            whereClause = (String)whereClause + " AND C_ProjectType_ID = ?";
            params.add(this.projectProcessor.getC_ProjectType_ID());
        }
        new ScheduleChange(this.getCtx(), "C_Project", (String)whereClauseGeneral + (String)whereClause, this.projectProcessor.get_TrxName()).setColumns("DueType", "DateLastAlert").setValues("7", currentDate).setAlertMessageColumn("@C_Project_ID@ @IsFor@ @Start@").setParameters(params).processScheduleChanges();
        whereClause = "";
        if (this.projectProcessor.getC_ProjectType_ID() != 0) {
            whereClause = (String)whereClause + " AND EXISTS (SELECT 1 FROM C_Project p WHERE p.C_Project_ID = C_ProjectPhase.C_Project_ID AND p.C_ProjectType_ID = ?)";
        }
        new ScheduleChange(this.getCtx(), "C_ProjectPhase", (String)whereClauseGeneral + (String)whereClause, this.projectProcessor.get_TrxName()).setColumns("DueType", "DateLastAlert").setValues("7", currentDate).setAlertMessageColumn("@C_ProjectPhase_ID@ @IsFor@ @Start@").setParameters(params).processScheduleChanges();
        whereClause = "";
        if (this.projectProcessor.getC_ProjectType_ID() != 0) {
            whereClause = (String)whereClause + " AND EXISTS (SELECT 1 FROM C_Project p INNER JOIN C_ProjectPhase ph ON (p.C_Project_ID = ph.C_Project_ID) WHERE ph.C_ProjectPhase_ID = C_ProjectTask.C_ProjectPhase_ID AND p.C_ProjectType_ID = ?)";
        }
        if (this.projectProcessor.getC_ProjectTaskCategory_ID() != 0) {
            whereClause = (String)whereClause + " AND C_ProjectTaskCategory_ID=?";
            params.add(this.projectProcessor.getC_ProjectTaskCategory_ID());
        }
        new ScheduleChange(this.getCtx(), "C_ProjectTask", (String)whereClauseGeneral + (String)whereClause, this.projectProcessor.get_TrxName()).setColumns("DueType", "DateLastAlert").setValues("7", currentDate).setAlertMessageColumn("@C_ProjectTask_ID@ @IsFor@ @Start@").setParameters(params).processScheduleChanges();
    }

    private void processDueAlert() {
        if (this.projectProcessor.getOverdueAlertDays() != 0) {
            Object whereClauseGeneral = "";
            Object whereClause = "";
            this.isScheduled = true;
            ArrayList<Object> params = new ArrayList<Object>();
            Timestamp currentDate = new Timestamp(TimeUtil.getToday().getTimeInMillis());
            whereClauseGeneral = "(COALESCE(DateDeadLine,DateFinishSchedule) IS NOT NULL) AND (DueType IS NULL OR DueType = ?) ";
            params.add("7");
            whereClauseGeneral = (String)whereClauseGeneral + " AND (COALESCE(DateDeadLine,DateFinishSchedule) + ? <= ? AND COALESCE(DateDeadLine,DateFinishSchedule) >= ?) ";
            params.add(this.projectProcessor.getOverdueAlertDays());
            params.add(currentDate);
            params.add(currentDate);
            whereClause = "AND  (DateFinish IS NULL) ";
            if (this.projectProcessor.getC_ProjectType_ID() != 0) {
                whereClause = (String)whereClause + " AND (C_ProjectType_ID = ?)";
                params.add(this.projectProcessor.getC_ProjectType_ID());
            }
            new ScheduleChange(this.getCtx(), "C_Project", (String)whereClauseGeneral + (String)whereClause, this.projectProcessor.get_TrxName()).setColumns("DueType", "DateLastAlert").setValues("5", currentDate).setAlertMessageColumn("@C_Project_ID@ @IsDue@").setParameters(params).processScheduleChanges();
            whereClause = "AND  (EndDate IS NULL) ";
            if (this.projectProcessor.getC_ProjectType_ID() != 0) {
                whereClause = (String)whereClause + " AND EXISTS (SELECT 1 FROM C_Project p WHERE p.C_Project_ID = C_ProjectPhase.C_Project_ID AND p.C_ProjectType_ID = ?) ";
            }
            new ScheduleChange(this.getCtx(), "C_ProjectPhase", (String)whereClauseGeneral + (String)whereClause, this.projectProcessor.get_TrxName()).setColumns("DueType", "DateLastAlert").setValues("5", currentDate).setAlertMessageColumn("@C_ProjectPhase_ID@ @IsDue@").setParameters(params).processScheduleChanges();
            whereClause = "AND  (DateFinish IS NULL) ";
            if (this.projectProcessor.getC_ProjectType_ID() != 0) {
                whereClause = (String)whereClause + " AND (EXISTS (SELECT 1 FROM C_Project p INNER JOIN C_ProjectPhase ph ON (p.C_Project_ID = ph.C_Project_ID) WHERE ph.C_ProjectPhase_ID = C_ProjectTask.C_ProjectPhase_ID AND p.C_ProjectType_ID = ?))";
            }
            if (this.projectProcessor.getC_ProjectTaskCategory_ID() != 0) {
                whereClause = (String)whereClause + " AND (C_ProjectTaskCategory_ID=?)";
                params.add(this.projectProcessor.getC_ProjectTaskCategory_ID());
            }
            new ScheduleChange(this.getCtx(), "C_ProjectTask", (String)whereClauseGeneral + (String)whereClause, this.projectProcessor.get_TrxName()).setColumns("DueType", "DateLastAlert").setValues("5", currentDate).setAlertMessageColumn("@C_ProjectTask_ID@ @IsDue@").setParameters(params).processScheduleChanges();
        }
    }

    private void processOverDueAlert() {
        if (this.projectProcessor.getOverdueAssignDays() != 0) {
            Object whereClauseGeneral = "";
            Object whereClause = "";
            this.isScheduled = true;
            ArrayList<Object> params = new ArrayList<Object>();
            Timestamp currentDate = new Timestamp(TimeUtil.getToday().getTimeInMillis());
            whereClauseGeneral = "(COALESCE(DateDeadLine,DateFinishSchedule) IS NOT NULL) AND (DueType IS NULL OR DueType IN (?,?,?)) ";
            params.add("7");
            params.add("5");
            params.add("3");
            whereClauseGeneral = (String)whereClauseGeneral + " AND (COALESCE(DateDeadLine,DateFinishSchedule) + ? >= ? AND COALESCE(DateDeadLine,DateFinishSchedule) < ?) ";
            params.add(this.projectProcessor.getOverdueAssignDays());
            params.add(currentDate);
            params.add(currentDate);
            whereClause = "AND  (DateFinish IS NULL) ";
            if (this.projectProcessor.getC_ProjectType_ID() != 0) {
                whereClause = (String)whereClause + " AND (C_ProjectType_ID = ?)";
                params.add(this.projectProcessor.getC_ProjectType_ID());
            }
            new ScheduleChange(this.getCtx(), "C_Project", (String)whereClauseGeneral + (String)whereClause, this.projectProcessor.get_TrxName()).setColumns("DueType", "DateLastAlert").setValues("3", currentDate).setAlertMessageColumn("@C_Project_ID@ @OverDue@").setParameters(params).processScheduleChanges();
            whereClause = "AND  (EndDate IS NULL) ";
            if (this.projectProcessor.getC_ProjectType_ID() != 0) {
                whereClause = (String)whereClause + " AND EXISTS (SELECT 1 FROM C_Project p WHERE p.C_Project_ID = C_ProjectPhase.C_Project_ID AND p.C_ProjectType_ID = ?) ";
            }
            new ScheduleChange(this.getCtx(), "C_ProjectPhase", (String)whereClauseGeneral + (String)whereClause, this.projectProcessor.get_TrxName()).setColumns("DueType", "DateLastAlert").setValues("3", currentDate).setAlertMessageColumn("@C_ProjectPhase_ID@ @OverDue@").setParameters(params).processScheduleChanges();
            whereClause = "AND  (DateFinish IS NULL) ";
            if (this.projectProcessor.getC_ProjectType_ID() != 0) {
                whereClause = (String)whereClause + " AND (EXISTS (SELECT 1 FROM C_Project p INNER JOIN C_ProjectPhase ph ON (p.C_Project_ID = ph.C_Project_ID) WHERE ph.C_ProjectPhase_ID = C_ProjectTask.C_ProjectPhase_ID AND p.C_ProjectType_ID = ?))";
            }
            if (this.projectProcessor.getC_ProjectTaskCategory_ID() != 0) {
                whereClause = (String)whereClause + " AND (C_ProjectTaskCategory_ID=?)";
                params.add(this.projectProcessor.getC_ProjectTaskCategory_ID());
            }
            new ScheduleChange(this.getCtx(), "C_ProjectTask", (String)whereClauseGeneral + (String)whereClause, this.projectProcessor.get_TrxName()).setColumns("DueType", "DateLastAlert").setValues("3", currentDate).setAlertMessageColumn("@C_ProjectTask_ID@ @OverDue@").setParameters(params).processScheduleChanges();
        }
    }

    public String getServerInfo() {
        return "Last=" + this.summary.toString();
    }

    private boolean loadMsgToSend(MProjectProcessorLog log) {
        MProjectProcessorChange[] changes = log.getChange(null);
        MProjectStatus status = null;
        String nameHeader = "";
        Object itemStatus = "";
        MUser createdBy = null;
        MUser updatedBy = null;
        if (changes.length == 0) {
            return false;
        }
        for (MProjectProcessorChange change : changes) {
            if (this.entity == null) {
                if (change.getAD_Table_ID() == MProject.Table_ID) {
                    this.project = new MProject(this.getCtx(), change.getRecord_ID(), change.get_TrxName());
                    this.entity = this.project;
                } else if (change.getAD_Table_ID() == MProjectPhase.Table_ID) {
                    this.projectPhase = new MProjectPhase(this.getCtx(), change.getRecord_ID(), change.get_TrxName());
                    this.project = (MProject)this.projectPhase.getC_Project();
                    this.entity = this.projectPhase;
                } else if (change.getAD_Table_ID() == MProjectTask.Table_ID) {
                    this.projectTask = new MProjectTask(this.getCtx(), change.getRecord_ID(), change.get_TrxName());
                    this.projectPhase = (MProjectPhase)this.projectTask.getC_ProjectPhase();
                    this.project = (MProject)this.projectPhase.getC_Project();
                    this.entity = this.projectPhase;
                }
            }
            if (this.entity != null && this.isScheduled) {
                this.extraMsg = this.entity.get_ValueAsString("AlertMessage");
            }
            if (change.getAD_Column_ID() == 0) continue;
            MColumn col = MColumn.get((Properties)change.getCtx(), (int)change.getAD_Column_ID());
            this.columns.add(col.getColumnName());
            this.values.add(change.getNewValue());
        }
        if (this.project != null) {
            this.prefixSubject = "[" + this.project.getName();
        }
        if (this.projectTask != null) {
            this.prefixTextMail = Msg.parseTranslation((Properties)log.getCtx(), (String)"@C_ProjectTask_ID@") + " #" + this.projectTask.getSeqNo();
            this.prefixSubject = this.prefixSubject + (Util.isEmpty((String)this.prefixSubject) ? "" : " - ") + this.prefixTextMail;
            nameHeader = this.projectTask.getName();
            createdBy = MUser.get((Properties)log.getCtx(), (int)this.projectTask.getCreatedBy());
            updatedBy = MUser.get((Properties)log.getCtx(), (int)this.projectTask.getUpdatedBy());
            if (this.projectTask.getC_ProjectStatus_ID() != 0) {
                status = (MProjectStatus)this.projectTask.getC_ProjectStatus();
                itemStatus = "(" + status.getName() + ")";
            }
        } else if (this.projectPhase != null) {
            this.prefixTextMail = Msg.parseTranslation((Properties)log.getCtx(), (String)"@C_ProjectPhase_ID@") + " #" + this.projectPhase.getSeqNo();
            this.prefixSubject = this.prefixSubject + (Util.isEmpty((String)this.prefixSubject) ? "" : " - ") + this.prefixTextMail;
            nameHeader = this.projectPhase.getName();
            createdBy = MUser.get((Properties)log.getCtx(), (int)this.projectPhase.getCreatedBy());
            updatedBy = MUser.get((Properties)log.getCtx(), (int)this.projectPhase.getUpdatedBy());
            if (this.projectPhase.getC_ProjectStatus_ID() != 0) {
                status = (MProjectStatus)this.projectPhase.getC_ProjectStatus();
                itemStatus = "(" + status.getName() + ")";
            }
        } else if (this.project != null) {
            this.prefixTextMail = Msg.parseTranslation((Properties)log.getCtx(), (String)"@C_Project_ID@") + " " + this.project.getName();
            createdBy = MUser.get((Properties)log.getCtx(), (int)this.project.getCreatedBy());
            updatedBy = MUser.get((Properties)log.getCtx(), (int)this.project.getUpdatedBy());
            if (this.project.getC_ProjectStatus_ID() != 0) {
                status = (MProjectStatus)this.project.getC_ProjectStatus();
                itemStatus = "(" + status.getName() + ")";
            }
        }
        if (!Util.isEmpty((String)this.prefixSubject)) {
            this.prefixSubject = this.prefixSubject + "] ";
        }
        this.prefixSubject = this.prefixSubject + (String)itemStatus + " " + nameHeader;
        if (log.getEventChangeLog() != null) {
            if (log.getEventChangeLog().equals("I") && createdBy != null) {
                this.prefixTextMail = this.prefixTextMail + " " + Msg.parseTranslation((Properties)log.getCtx(), (String)"@CreatedBy@") + " " + createdBy.getName();
            } else if (log.getEventChangeLog().equals("U") && updatedBy != null) {
                this.prefixTextMail = this.prefixTextMail + " " + Msg.parseTranslation((Properties)log.getCtx(), (String)"@UpdatedBy@") + " " + updatedBy.getName();
            }
            this.textNotice = this.prefixTextMail;
            StringBuffer sb = new StringBuffer("<HR>\n").append(this.prefixTextMail + "\n").append(this.getMessageColumnsChanged()).append(this.getMessageColumnsStatic());
            this.prefixTextMail = sb.toString();
        }
        return true;
    }

    private String getMessageColumnsChanged() {
        StringBuffer sb = new StringBuffer();
        if (this.columns.size() > 0 || !Util.isEmpty((String)this.extraMsg)) {
            sb.append("<ul>\n");
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            String column = this.columns.get(i);
            if (ProjectProcessorService.isExcludeColumn((String)column)) continue;
            String value = this.values.get(i);
            String item = this.getItemPO(column, value);
            this.textNotice = this.textNotice + item + "\n";
            sb.append(item);
        }
        if (!Util.isEmpty((String)this.extraMsg)) {
            sb.append("<li><strong>" + this.extraMsg + "</li></strong>");
            this.textNotice = this.textNotice + this.extraMsg + "\n";
        }
        if (this.columns.size() > 0 || !Util.isEmpty((String)this.extraMsg)) {
            sb.append("</ul>\n").append("<HR>\n");
        }
        return sb.toString();
    }

    private String getMessageColumnsStatic() {
        StringBuffer sb = new StringBuffer();
        Object result = "";
        if (this.entity != null) {
            for (String column : ProjectProcessorService.RESPONSIBLE_COLUMNS) {
                if (this.entity.get_ColumnIndex(column) < 0) continue;
                sb.append(this.getItemPO(column, null));
            }
            for (String column : ProjectProcessorService.INFO_COLUMNS) {
                if (this.entity.get_ColumnIndex(column) < 0) continue;
                sb.append(this.getItemPO(column, null));
            }
            for (String column : ProjectProcessorService.TIME_COLUMNS) {
                if (this.entity.get_ColumnIndex(column) < 0) continue;
                sb.append(this.getItemPO(column, null));
            }
            if (sb.length() > 0) {
                result = "<ul>\n " + sb.toString() + "</ul>\n <HR>\n ";
            }
        }
        return result;
    }

    private String getItemPO(String column, String value) {
        StringBuffer result = new StringBuffer();
        result.append("<li><strong>" + Msg.parseTranslation((Properties)this.entity.getCtx(), (String)("@" + column + "@")) + ":</strong> ");
        if (value != null) {
            result.append(value);
        } else {
            result.append(ProjectProcessorService.getDisplayValue((String)column, (PO)this.entity));
        }
        result.append("</li>\n");
        return result.toString();
    }

    private void clearGlobals() {
        this.prefixSubject = "";
        this.prefixTextMail = "";
        this.columns.clear();
        this.values.clear();
        this.entity = null;
        this.project = null;
        this.projectPhase = null;
        this.projectTask = null;
        this.extraMsg = "";
        this.textNotice = "";
        this.isScheduled = false;
    }
}

