/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca46.process;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MChangeRequest;
import org.compiere.model.MClient;
import org.compiere.model.MGroup;
import org.compiere.model.MMailText;
import org.compiere.model.MRequest;
import org.compiere.model.MRequestProcessor;
import org.compiere.model.MRequestProcessorLog;
import org.compiere.model.MRequestProcessorRoute;
import org.compiere.model.MStatus;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.spin.eca46.process.RequestProcessorAbstract;
import org.spin.model.MRNoticeTemplate;
import org.spin.queue.notification.DefaultNotifier;
import org.spin.queue.util.QueueLoader;

public class RequestProcessor
extends RequestProcessorAbstract {
    private MClient client = null;
    private MRequestProcessor requestProcessor = null;
    private StringBuffer summary = new StringBuffer();
    private int count = 0;
    private int mailCount = 0;
    private long startWork;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRequestProcessorId() <= 0) {
            throw new AdempiereException("@R_RequestProcessor_ID@ @NotFound@");
        }
        this.requestProcessor = new MRequestProcessor(this.getCtx(), this.getRequestProcessorId(), this.get_TrxName());
        this.client = MClient.get((Properties)this.getCtx(), (int)this.requestProcessor.getAD_Client_ID());
    }

    protected String doIt() throws Exception {
        this.startWork = System.currentTimeMillis();
        this.summary = new StringBuffer();
        this.processEMail();
        this.findSalesRep();
        this.processStatus();
        this.processRequests();
        this.processECR();
        int no = this.requestProcessor.deleteLog();
        this.summary.append("Logs deleted=").append(no);
        if (this.requestProcessor.get_TrxName() == null) {
            this.addRequestProcessorLog(this.requestProcessor.get_TrxName());
        } else {
            Trx.run(this::addRequestProcessorLog);
        }
        return TimeUtil.formatElapsed((Timestamp)new Timestamp(this.startWork));
    }

    private void addRequestProcessorLog(String trxName) {
        MRequestProcessorLog requestProcessorLog = new MRequestProcessorLog(this.requestProcessor, this.summary.toString(), trxName);
        requestProcessorLog.setReference(TimeUtil.formatElapsed((Timestamp)new Timestamp(this.startWork)));
        requestProcessorLog.saveEx();
    }

    private void processRequests() {
        this.resetCounter();
        StringBuffer whereClause = new StringBuffer();
        ArrayList<Object> parameters = new ArrayList<Object>();
        this.resetCounter();
        whereClause = new StringBuffer("DueType = ? AND Processed = 'N' AND AD_Client_ID = ?");
        parameters = new ArrayList();
        parameters.add("7");
        parameters.add(this.requestProcessor.getAD_Client_ID());
        if (this.requestProcessor.getR_RequestType_ID() != 0) {
            whereClause.append(" AND R_RequestType_ID = ?");
            parameters.add(this.requestProcessor.getR_RequestType_ID());
        }
        whereClause.append(" AND DateNextAction < SysDate");
        new Query(this.getCtx(), "R_Request", whereClause.toString(), null).setParameters(parameters).list().forEach(request -> {
            request.setDueType();
            if (request.isDue()) {
                if (request.getRequestType().isEMailWhenDue() && this.sendEmail((MRequest)request, "SRLRA")) {
                    request.setDateLastAlert();
                    this.addMailCount();
                }
                request.saveEx();
                this.addRecordCount();
            }
        });
        this.summary.append("New Due #").append(this.count);
        if (this.mailCount > 0) {
            this.summary.append(" (").append(this.mailCount).append(" EMail)");
        }
        this.summary.append(" - ");
        this.resetCounter();
        whereClause = new StringBuffer("DueType = ? AND Processed = 'N' AND AD_Client_ID = ?");
        parameters = new ArrayList();
        parameters.add("5");
        parameters.add(this.requestProcessor.getAD_Client_ID());
        if (this.requestProcessor.getR_RequestType_ID() != 0) {
            whereClause.append(" AND R_RequestType_ID = ?");
            parameters.add(this.requestProcessor.getR_RequestType_ID());
        }
        whereClause.append(" AND EXISTS(SELECT 1 FROM R_RequestType rt WHERE R_Request.R_RequestType_ID = rt.R_RequestType_ID AND (R_Request.DateNextAction+rt.DueDateTolerance) < SysDate)");
        new Query(this.getCtx(), "R_Request", whereClause.toString(), null).setParameters(parameters).list().forEach(request -> {
            request.setDueType();
            if (request.isOverdue()) {
                if (request.getRequestType().isEMailWhenOverdue() && !TimeUtil.isSameDay((Timestamp)request.getDateLastAlert(), null) && this.sendEmail((MRequest)request, "ATETA")) {
                    request.setDateLastAlert();
                    this.addMailCount();
                }
                request.saveEx();
                this.addRecordCount();
            }
        });
        this.summary.append("New Overdue #").append(this.count);
        if (this.mailCount > 0) {
            this.summary.append(" (").append(this.mailCount).append(" EMail)");
        }
        this.summary.append(" - ");
        if (this.requestProcessor.getOverdueAlertDays() > 0) {
            this.resetCounter();
            whereClause = new StringBuffer("Processed = 'N' AND AD_Client_ID = ?");
            parameters = new ArrayList();
            parameters.add(this.requestProcessor.getAD_Client_ID());
            whereClause.append(" AND (DateNextAction+" + this.requestProcessor.getOverdueAlertDays() + ") < SysDate AND (DateLastAlert IS NULL");
            if (this.requestProcessor.getRemindDays() > 0) {
                whereClause.append(" OR (DateLastAlert+" + this.requestProcessor.getRemindDays() + ") < SysDate");
            }
            whereClause.append(")");
            if (this.requestProcessor.getR_RequestType_ID() != 0) {
                whereClause.append(" AND R_RequestType_ID = ?");
                parameters.add(this.requestProcessor.getR_RequestType_ID());
            }
            new Query(this.getCtx(), "R_Request", whereClause.toString(), null).setParameters(parameters).list().forEach(request -> {
                request.setDueType();
                if (request.getRequestType().isEMailWhenOverdue() && (request.getDateLastAlert() == null || !TimeUtil.isSameDay((Timestamp)request.getDateLastAlert(), null))) {
                    if (this.sendEmail((MRequest)request, "ATETA")) {
                        request.setDateLastAlert();
                        this.addMailCount();
                    }
                    request.saveEx();
                    this.addRecordCount();
                }
            });
            this.summary.append("Alerts #").append(this.count);
            if (this.mailCount > 0) {
                this.summary.append(" (").append(this.mailCount).append(" EMail)");
            }
            this.summary.append(" - ");
        }
        if (this.requestProcessor.getOverdueAssignDays() > 0) {
            this.resetCounter();
            whereClause = new StringBuffer("Processed = 'N' AND AD_Client_ID = ? AND IsEscalated='N'");
            parameters = new ArrayList();
            parameters.add(this.requestProcessor.getAD_Client_ID());
            whereClause.append(" AND (DateNextAction+" + this.requestProcessor.getOverdueAssignDays() + ") < SysDate");
            if (this.requestProcessor.getR_RequestType_ID() != 0) {
                whereClause.append(" AND R_RequestType_ID = ?");
                parameters.add(this.requestProcessor.getR_RequestType_ID());
            }
            new Query(this.getCtx(), "R_Request", whereClause.toString(), null).setParameters(parameters).list().forEach(request -> {
                if (this.escalate((MRequest)request)) {
                    this.addRecordCount();
                }
            });
            this.summary.append("Escalated #").append(this.count).append(" - ");
        }
        if (this.requestProcessor.getInactivityAlertDays() > 0) {
            this.resetCounter();
            whereClause = new StringBuffer("Processed = 'N' AND AD_Client_ID = ?");
            parameters = new ArrayList();
            parameters.add(this.requestProcessor.getAD_Client_ID());
            whereClause.append(" AND (Updated+" + this.requestProcessor.getInactivityAlertDays() + ") < SysDate AND (DateLastAlert IS NULL");
            if (this.requestProcessor.getRemindDays() > 0) {
                whereClause.append(" OR (DateLastAlert+" + this.requestProcessor.getRemindDays() + ") < SysDate");
            }
            whereClause.append(")");
            if (this.requestProcessor.getR_RequestType_ID() != 0) {
                whereClause.append(" AND R_RequestType_ID = ?");
                parameters.add(this.requestProcessor.getR_RequestType_ID());
            }
            new Query(this.getCtx(), "R_Request", whereClause.toString(), null).setParameters(parameters).list().forEach(request -> {
                if (request.getDateLastAlert() == null || !TimeUtil.isSameDay((Timestamp)request.getDateLastAlert(), null)) {
                    if (this.sendEmail((MRequest)request, "ATETA")) {
                        request.setDateLastAlert();
                        this.addMailCount();
                    }
                    request.saveEx();
                    this.addRecordCount();
                }
            });
            this.summary.append("Inactivity #").append(this.count).append(" - ");
            if (this.mailCount > 0) {
                this.summary.append(" (").append(this.mailCount).append(" EMail)");
            }
            this.summary.append(" - ");
        }
    }

    private boolean sendEmail(MRequest request, String eventType) {
        MMailText mailText;
        AtomicReference<String> subject = new AtomicReference<String>();
        AtomicReference<String> message = new AtomicReference<String>();
        if (!Util.isEmpty((String)eventType) && (mailText = MRNoticeTemplate.getMailTemplate((Properties)this.getCtx(), (String)"R", (String)eventType)) != null) {
            mailText.setPO((PO)request, true);
            subject.set(mailText.getMailHeader());
            message.set(mailText.getMailText(true));
        }
        if (Util.isEmpty((String)((String)subject.get())) && Util.isEmpty((String)((String)message.get()))) {
            subject.set(Msg.getMsg((String)this.client.getAD_Language(), (String)"RequestDue", (Object[])new String[]{request.getDocumentNo()}));
            message.set(request.getSummary());
        }
        Trx.run(transactionName -> {
            try {
                DefaultNotifier notifier = (DefaultNotifier)QueueLoader.getInstance().getQueueManager("NTF").withContext(this.getCtx()).withTransactionName(transactionName);
                notifier.clearMessage().withApplicationType("UDP").withUserId(request.getUpdatedBy()).addRecipient(request.getSalesRep_ID()).withText((String)message.get()).addAttachment(request.createPDF()).withDescription((String)subject.get());
                notifier.addToQueue();
            }
            catch (Exception e) {
                this.log.severe(e.getLocalizedMessage());
            }
        });
        return true;
    }

    private boolean escalate(MRequest request) {
        MUser supervisor = request.getSalesRep();
        int supervisor_ID = request.getSalesRep().getSupervisor_ID();
        if (supervisor_ID == 0 && this.requestProcessor.getSupervisor_ID() != 0) {
            supervisor_ID = this.requestProcessor.getSupervisor_ID();
        }
        if (supervisor_ID != 0 && supervisor_ID != request.getAD_User_ID()) {
            supervisor = MUser.get((Properties)this.getCtx(), (int)supervisor_ID);
        }
        AtomicReference<String> subject = new AtomicReference<String>();
        AtomicReference<String> message = new AtomicReference<String>();
        MMailText mailText = MRNoticeTemplate.getMailTemplate((Properties)this.getCtx(), (String)"R", (String)"ATTTN");
        if (mailText != null) {
            mailText.setPO((PO)request, true);
            subject.set(mailText.getMailHeader());
            message.set(mailText.getMailText(true));
        }
        if (Util.isEmpty((String)((String)subject.get())) && Util.isEmpty((String)((String)message.get()))) {
            subject.set(Msg.getMsg((String)this.client.getAD_Language(), (String)"RequestEscalate", (Object[])new String[]{request.getDocumentNo(), supervisor.getName()}));
            message.set(request.getSummary());
        }
        ArrayList<Integer> recipients = new ArrayList<Integer>();
        recipients.add(request.getSalesRep_ID());
        if (request.getSalesRep_ID() != supervisor.getAD_User_ID()) {
            recipients.add(supervisor.getAD_User_ID());
        }
        Trx.run(transactionName -> {
            DefaultNotifier notifier = (DefaultNotifier)QueueLoader.getInstance().getQueueManager("NTF").withContext(this.getCtx()).withTransactionName(transactionName);
            notifier.clearMessage().withApplicationType("UDP").withText((String)message.get()).addAttachment(request.createPDF()).withDescription((String)subject.get());
            recipients.forEach(recipientId -> notifier.addRecipient(recipientId.intValue()));
            notifier.addToQueue();
        });
        request.setDueType();
        request.setIsEscalated(true);
        request.setResult((String)subject.get());
        return request.save();
    }

    private void addRecordCount() {
        ++this.count;
    }

    private void addMailCount() {
        ++this.mailCount;
    }

    private void resetCounter() {
        this.count = 0;
        this.mailCount = 0;
    }

    private void processStatus() {
        this.resetCounter();
        StringBuffer whereClause = new StringBuffer("EXISTS(SELECT 1 FROM R_Status s WHERE R_Request.R_Status_ID=s.R_Status_ID AND s.TimeoutDays > 0 AND s.Next_Status_ID > 0 AND R_Request.DateLastAction+s.TimeoutDays < SysDate)");
        new Query(this.getCtx(), "R_Request", whereClause.toString(), null).setOrderBy("R_Status_ID").list().stream().filter(request -> MStatus.get((Properties)this.getCtx(), (int)request.getR_Status_ID()).getTimeoutDays() > 0 && MStatus.get((Properties)this.getCtx(), (int)request.getR_Status_ID()).getNext_Status_ID() > 0).forEach(request -> {
            MStatus status = MStatus.get((Properties)this.getCtx(), (int)request.getR_Status_ID());
            MStatus next = MStatus.get((Properties)this.getCtx(), (int)status.getNext_Status_ID());
            String result = Msg.getMsg((Properties)this.getCtx(), (String)"RequestStatusTimeout") + ": " + status.getName() + " -> " + next.getName();
            request.setResult(result);
            request.setR_Status_ID(status.getNext_Status_ID());
            if (request.save()) {
                this.addRecordCount();
            }
        });
        this.summary.append("Status Timeout #").append(this.count).append(" - ");
    }

    private void processECR() {
        this.resetCounter();
        StringBuffer whereClause = new StringBuffer("M_ChangeRequest_ID IS NULL AND EXISTS(SELECT 1 FROM R_RequestType rt WHERE rt.R_RequestType_ID = R_Request.R_RequestType_ID AND rt.IsAutoChangeRequest='Y')AND EXISTS (SELECT 1 FROM R_Group g WHERE g.R_Group_ID = R_Request.R_Group_ID AND (g.M_BOM_ID IS NOT NULL OR g.M_ChangeNotice_ID IS NOT NULL)\t)");
        new Query(this.getCtx(), "R_Request", whereClause.toString(), null).setOrderBy("R_Status_ID").list().forEach(request -> {
            MGroup requestGroup = MGroup.get((Properties)this.getCtx(), (int)request.getR_Group_ID());
            MChangeRequest changeRequest = new MChangeRequest(request, requestGroup);
            if (request.save()) {
                request.setM_ChangeRequest_ID(changeRequest.getM_ChangeRequest_ID());
                if (request.save()) {
                    this.addMailCount();
                }
            }
            this.addRecordCount();
        });
        this.summary.append("Auto Change Request #").append(this.count);
        if (this.count - this.mailCount > 0) {
            this.summary.append("(fail=").append(this.count - this.mailCount).append(")");
        }
        this.summary.append(" - ");
    }

    private void processEMail() {
    }

    private void findSalesRep() {
        StringBuffer whereClause = new StringBuffer("Processed = 'N' AND AD_Client_ID = ? AND (SalesRep_ID = 0 OR SalesRep_ID IS NULL)");
        ArrayList<Integer> parameters = new ArrayList<Integer>();
        parameters.add(this.requestProcessor.getAD_Client_ID());
        this.resetCounter();
        new Query(this.getCtx(), "R_Request", whereClause.toString(), null).setParameters(parameters).list().forEach(request -> {
            int salesRepId = this.findSalesRep((MRequest)request);
            if (salesRepId != 0) {
                request.setSalesRep_ID(salesRepId);
                if (request.save()) {
                    this.addMailCount();
                }
            }
            this.addRecordCount();
        });
        if (this.mailCount == 0 && this.count - this.mailCount == 0) {
            this.summary.append("No unallocated Requests");
        } else {
            this.summary.append("Allocated SalesRep=").append(this.mailCount);
        }
        if (this.count - this.mailCount > 0) {
            this.summary.append(",Not=").append(this.count - this.mailCount);
        }
        this.summary.append(" - ");
    }

    private int findSalesRep(MRequest request) {
        String QText = request.getSummary();
        QText = QText == null ? "" : QText.toUpperCase();
        MRequestProcessorRoute[] routes = this.requestProcessor.getRoutes(false);
        for (int i = 0; i < routes.length; ++i) {
            MRequestProcessorRoute route = routes[i];
            if (request.getR_RequestType_ID() == route.getR_RequestType_ID() && route.getR_RequestType_ID() != 0) {
                return route.getAD_User_ID();
            }
            String keyword = route.getKeyword();
            if (keyword == null) continue;
            StringTokenizer st = new StringTokenizer(keyword.toUpperCase(), " ,;\t\n\r\f");
            while (st.hasMoreElements()) {
                if (QText.indexOf(st.nextToken()) == -1) continue;
                return route.getAD_User_ID();
            }
        }
        return this.requestProcessor.getSupervisor_ID();
    }

    public String getServerInfo() {
        return "Last=" + this.summary.toString();
    }
}

