/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca46.process;

import java.util.List;
import java.util.Properties;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Msg;
import org.eevolution.model.MProjectStatus;

class ScheduleChange {
    private Properties ctx = null;
    private String trxName = null;
    private String tableName = null;
    private String whereClause = null;
    private String[] columnsToSet = new String[0];
    private Object[] valuesToSet = new Object[0];
    private Object[] parameters = new Object[0];
    private StringBuffer message = new StringBuffer();
    private boolean nextProjectStatus = false;

    public ScheduleChange(Properties ctx, String tableName, String whereClause, String trxName) {
        this.ctx = ctx;
        this.tableName = tableName;
        this.whereClause = whereClause;
        this.trxName = trxName;
    }

    public ScheduleChange setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public ScheduleChange setWhereClause(String whereClause) {
        this.whereClause = whereClause;
        return this;
    }

    public ScheduleChange setColumns(String ... columns) {
        this.columnsToSet = columns;
        return this;
    }

    public ScheduleChange setValues(Object ... values) {
        this.valuesToSet = values;
        return this;
    }

    public ScheduleChange setParameters(Object ... parameters) {
        this.parameters = parameters;
        return this;
    }

    public ScheduleChange setParameters(List<Object> parameters) {
        this.parameters = parameters.toArray();
        return this;
    }

    public ScheduleChange setAlertMessageColumn(String message) {
        this.message.append(Msg.parseTranslation((Properties)this.ctx, (String)message));
        return this;
    }

    public ScheduleChange IsNextProjectStatus() {
        this.nextProjectStatus = true;
        return this;
    }

    public void processScheduleChanges() {
        List entitys = new Query(this.ctx, this.tableName, this.whereClause, this.trxName).setParameters(this.parameters).list();
        for (PO entity : entitys) {
            int projecStatusID;
            for (int i = 0; i < this.columnsToSet.length; ++i) {
                entity.set_ValueOfColumn(this.columnsToSet[i], this.valuesToSet[i]);
            }
            if (this.nextProjectStatus && entity.get_ColumnIndex("C_ProjectStatus_ID") >= 0 && (projecStatusID = entity.get_ValueAsInt("C_ProjectStatus_ID")) > 0) {
                MProjectStatus pStatus = MProjectStatus.get((Properties)this.ctx, (int)entity.get_ValueAsInt("C_ProjectStatus_ID"));
                entity.set_ValueOfColumn("C_ProjectStatus_ID", (Object)this.getNextStatus(pStatus));
            }
            if (this.message.length() > 0) {
                entity.set_CustomColumn("AlertMessage", (Object)this.message.toString());
            }
            entity.save();
        }
    }

    private int getNextStatus(MProjectStatus projectStatus) {
        if (projectStatus.getTimeoutDays() <= 0 || projectStatus.getNext_Status_ID() == 0) {
            return projectStatus.getC_ProjectStatus_ID();
        }
        return projectStatus.getNext_Status_ID();
    }
}

